/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.suppress;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.inspections.suppress.CssSuppressionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssInspectionSuppressor
implements InspectionSuppressor {
    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/inspections/suppress/CssInspectionSuppressor", "isSuppressedFor"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/psi/css/inspections/suppress/CssInspectionSuppressor", "isSuppressedFor"));
        }
        CssCharset charset = (CssCharset)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssCharset.class});
        if (charset != null) {
            return false;
        }
        InspectionSuppressor preprocessorSuppressor = this.getPreprocessorSuppressor(element);
        return preprocessorSuppressor != null ? preprocessorSuppressor.isSuppressedFor(element, toolId) : CssSuppressionUtil.isSuppressedFor(element, toolId);
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/psi/css/inspections/suppress/CssInspectionSuppressor", "getSuppressActions"));
        }
        CssCharset charset = (CssCharset)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssCharset.class});
        if (charset != null) {
            if (SuppressQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/suppress/CssInspectionSuppressor", "getSuppressActions"));
            }
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        InspectionSuppressor preprocessorSuppressor = element != null ? this.getPreprocessorSuppressor(element) : null;
        SuppressQuickFix[] suppressQuickFixArray = preprocessorSuppressor != null ? preprocessorSuppressor.getSuppressActions(element, toolId) : CssSuppressionUtil.getSuppressQuickFixes(toolId);
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/suppress/CssInspectionSuppressor", "getSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    @Nullable
    private InspectionSuppressor getPreprocessorSuppressor(@NotNull PsiElement context) {
        InspectionSuppressor preprocessorSuppressor;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/inspections/suppress/CssInspectionSuppressor", "getPreprocessorSuppressor"));
        }
        Language stylesheetLanguage = CssPsiUtil.getStylesheetLanguage((PsiElement)context);
        if (stylesheetLanguage != null && stylesheetLanguage != CSSLanguage.INSTANCE && (preprocessorSuppressor = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(stylesheetLanguage)) != this) {
            return preprocessorSuppressor;
        }
        return null;
    }
}

