/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssInvalidFunctionInspection
extends CssBaseInspection {
    private static final CssInspectionsUtil.CssInvalidValueRangeProvider INVALID_VALUE_RANGE_PROVIDER = new CssFunctionInvalidValueRangeProvider();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidFunctionInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssFunction(@NotNull CssFunction function) {
                if (function == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/psi/css/inspections/invalid/CssInvalidFunctionInspection$1", "visitCssFunction"));
                }
                if (function.getParent() instanceof CssPseudoSelector) {
                    return;
                }
                String name = function.getName();
                PsiElement nameIdentifier = function.getNameIdentifier();
                if (name.isEmpty() || nameIdentifier == null) {
                    return;
                }
                Collection descriptors = function.getDescriptors();
                if (descriptors.isEmpty()) {
                    holder.registerProblem(nameIdentifier, CssBundle.message((String)"css.inspections.invalid.function.unknown.message", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    return;
                }
                Collection filteredByContextDescriptors = CssInspectionsUtil.filterDescriptorsByContextAndCheck(descriptors, nameIdentifier, holder);
                CssInspectionsUtil.checkDescriptorValue(filteredByContextDescriptors, (CssValueOwner)function, holder, "css.inspections.function.mismatched.parameters", INVALID_VALUE_RANGE_PROVIDER, false, false, false);
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssInvalidFunctionInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }

    private static class CssFunctionInvalidValueRangeProvider
    extends CssInspectionsUtil.CssInvalidValueRangeProvider {
        private CssFunctionInvalidValueRangeProvider() {
        }

        @Override
        public TextRange calculateInvalidRange(@NotNull CssValueOwner valueOwner, @Nullable PsiElement lastMatchedElement, @NotNull TextRange defaultValue) {
            if (valueOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueOwner", "com/intellij/psi/css/inspections/invalid/CssInvalidFunctionInspection$CssFunctionInvalidValueRangeProvider", "calculateInvalidRange"));
            }
            if (defaultValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/psi/css/inspections/invalid/CssInvalidFunctionInspection$CssFunctionInvalidValueRangeProvider", "calculateInvalidRange"));
            }
            if (valueOwner instanceof CssFunction) {
                CssFunction function = (CssFunction)valueOwner;
                TextRange functionTextRange = function.getTextRange();
                int functionStartOffset = functionTextRange.getStartOffset();
                if (lastMatchedElement != null) {
                    TextRange range;
                    PsiElement rParenthesis;
                    int endOfValue;
                    int startOfInvalidElements = lastMatchedElement.getTextRange().getEndOffset();
                    if (startOfInvalidElements == (endOfValue = Math.max(function.getTrimmedValueTextRange().getEndOffset(), startOfInvalidElements)) && (rParenthesis = function.getRParenthesis()) != null) {
                        endOfValue = rParenthesis.getTextRange().getEndOffset();
                    }
                    if (!(range = TextRange.create((int)startOfInvalidElements, (int)endOfValue)).isEmpty()) {
                        return range.shiftRight(-functionStartOffset);
                    }
                }
            }
            return super.calculateInvalidRange(valueOwner, lastMatchedElement, defaultValue);
        }
    }
}

