/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssFixFactory;
import org.jetbrains.annotations.NotNull;

public class CssMissingCommaInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/bugs/CssMissingCommaInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssSelector(CssSelector selector) {
                super.visitCssSelector(selector);
                CssSimpleSelector[] simpleSelectors = selector.getSimpleSelectors();
                block0: for (int i = 0; i < simpleSelectors.length - 1; ++i) {
                    CssSimpleSelector simpleSelector = simpleSelectors[i];
                    if (simpleSelector.getTextRange().isEmpty()) continue;
                    for (PsiElement nextSibling = simpleSelector.getNextSibling(); nextSibling != null && !(nextSibling instanceof CssSimpleSelector); nextSibling = nextSibling.getNextSibling()) {
                        if (!(nextSibling instanceof PsiWhiteSpace) || !nextSibling.textContains('\n')) continue;
                        String nextSiblingText = nextSibling.getText();
                        int newLineIndex = StringUtil.indexOf((CharSequence)nextSiblingText, (char)'\n');
                        LocalQuickFix[] fixes = new LocalQuickFix[]{CssFixFactory.getInstance().insertCommaAfterSelector(simpleSelector)};
                        String message = CssBundle.message((String)"css.inspections.missing.comma", (Object[])new Object[0]);
                        if (newLineIndex > 0) {
                            holder.registerProblem(nextSibling, TextRange.create((int)0, (int)newLineIndex), message, fixes);
                            continue block0;
                        }
                        ProblemDescriptor problemDescriptor = holder.getManager().createProblemDescriptor((PsiElement)simpleSelector, message, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, true);
                        holder.registerProblem(problemDescriptor);
                        continue block0;
                    }
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/bugs/CssMissingCommaInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }
}

