/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssSimpleSelector;
import org.jetbrains.annotations.NotNull;

public class CssReplaceHtmlTagReferenceWithIdIntentionAction
implements LocalQuickFix {
    private final String myTagName;

    public CssReplaceHtmlTagReferenceWithIdIntentionAction(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/psi/css/inspections/CssReplaceHtmlTagReferenceWithIdIntentionAction", "<init>"));
        }
        this.myTagName = tagName;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"css.invalid.invalid.html.tag.reference.id.action", (Object[])new Object[]{this.myTagName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssReplaceHtmlTagReferenceWithIdIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/CssReplaceHtmlTagReferenceWithIdIntentionAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/CssReplaceHtmlTagReferenceWithIdIntentionAction", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        CssElementFactory factory = CssElementFactory.getInstance((Project)project);
        CssSimpleSelector newSelector = factory.createSimpleSelector("#" + element.getText(), CssPsiUtil.getStylesheetLanguage((PsiElement)element));
        element.replace((PsiElement)newSelector);
    }
}

