/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.actions.CssInsertGenericFontFamilyIntention;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.css.inspections.CssInsertCommaAfterSelectorFix;
import com.intellij.psi.css.inspections.CssUnknownPropertyIntentionAction;
import com.intellij.psi.css.inspections.InsertUnitQualifier;
import com.intellij.psi.css.inspections.RemoveUnusedSymbolIntentionAction;
import com.intellij.psi.css.inspections.RoundPxValueQuickFix;
import com.intellij.psi.css.inspections.fixes.CssReplacePseudoPrefixQuickFix;
import org.jetbrains.annotations.NotNull;

public class CssFixFactoryImpl
extends CssFixFactory {
    @Override
    public LocalQuickFix removeUnusedSymbolIntentionAction(@NotNull String element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/inspections/CssFixFactoryImpl", "removeUnusedSymbolIntentionAction"));
        }
        return new RemoveUnusedSymbolIntentionAction(element);
    }

    @Override
    public LocalQuickFix insertUnitQualifier(CssDeclaration declaration) {
        return new InsertUnitQualifier(declaration);
    }

    @Override
    public LocalQuickFix replacePseudoPrefixQuickFix(int givenPrefixLength, int expectedPrefixLength) {
        return new CssReplacePseudoPrefixQuickFix(givenPrefixLength, expectedPrefixLength);
    }

    @Override
    public LocalQuickFix roundPxValueQuickFix() {
        return new RoundPxValueQuickFix();
    }

    @Override
    public LocalQuickFix cssUnknownPropertyIntentionAction(String postfix) {
        return new CssUnknownPropertyIntentionAction(postfix);
    }

    @Override
    public LocalQuickFix insertGenericFontFamilyAction(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/inspections/CssFixFactoryImpl", "insertGenericFontFamilyAction"));
        }
        return new CssInsertGenericFontFamilyIntention(declaration);
    }

    @Override
    public LocalQuickFix insertCommaAfterSelector(@NotNull CssSimpleSelector simpleSelector) {
        if (simpleSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleSelector", "com/intellij/psi/css/inspections/CssFixFactoryImpl", "insertCommaAfterSelector"));
        }
        return new CssInsertCommaAfterSelectorFix(simpleSelector);
    }
}

