/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.index;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.css.CssFileType;
import org.jetbrains.annotations.NotNull;

public abstract class CssSupportedFileTypesProvider {
    public static final ExtensionPointName<CssSupportedFileTypesProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.css.supportedFileTypesProvider");

    public abstract LanguageFileType getSupportedFileType();

    public abstract Language getLanguage();

    public abstract Lexer getIndexingLexer();

    public static boolean isSupportedFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/css/index/CssSupportedFileTypesProvider", "isSupportedFileType"));
        }
        if (fileType == CssFileType.INSTANCE) {
            return true;
        }
        for (CssSupportedFileTypesProvider extension : (CssSupportedFileTypesProvider[])Extensions.getExtensions(EP_NAME)) {
            if (extension.getSupportedFileType() != fileType) continue;
            return true;
        }
        return false;
    }
}

