/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssCompletionContext;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.impl.util.table.CssTableValueBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPropertyValueImpl
extends CssTableValueBase<CssPropertyValue, Object>
implements CssPropertyValue {
    private String myRefName;
    private boolean myComplete = true;

    public CssPropertyValueImpl(CssTableValue.Type type) {
        super(type);
    }

    public CssPropertyValueImpl(@NonNls Object v) {
        super(v);
    }

    public boolean isComplete() {
        return this.myComplete;
    }

    public void setComplete(boolean complete) {
        this.myComplete = complete;
    }

    @Nullable
    public String getRefName() {
        return this.myRefName;
    }

    public void setRefName(@NotNull String refName) {
        if (refName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refName", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "setRefName"));
        }
        this.myRefName = refName;
    }

    public int getMaxCompletionContextLength() {
        return this.computeValuesCount(true);
    }

    public int getMaxValuesCount() {
        return this.computeValuesCount(false);
    }

    private int computeValuesCount(boolean completedOnly) {
        if (!completedOnly || this.isComplete()) {
            if (this.isGroup()) {
                CssTableValue.Type type = this.getType();
                int result = 0;
                if (CssTableValue.Type.ANY == type || CssTableValue.Type.DEFAULT == type) {
                    for (CssPropertyValue each : this.getChildren()) {
                        if (result >= Integer.MAX_VALUE) continue;
                        int inc = each.isGroup() ? ((CssPropertyValueImpl)each).computeValuesCount(completedOnly) : 1;
                        result = inc < Integer.MAX_VALUE ? result + inc : Integer.MAX_VALUE;
                    }
                    return result;
                }
                for (CssPropertyValue each : this.getChildren()) {
                    int childLength = each.isGroup() ? ((CssPropertyValueImpl)each).computeValuesCount(completedOnly) : 1;
                    result = result < childLength ? childLength : result;
                }
                int maxCount = this.getMaxCount();
                int minCount = this.getMinCount();
                if (minCount == -1 && maxCount == -1) {
                    return result;
                }
                if (maxCount == -1) {
                    return Integer.MAX_VALUE;
                }
                return result * maxCount;
            }
            int maxCount = this.getMaxCount();
            int minCount = this.getMinCount();
            if (-1 == minCount && -1 == maxCount) {
                return 1;
            }
            if (-1 == maxCount) {
                return Integer.MAX_VALUE;
            }
            return maxCount;
        }
        return 0;
    }

    public int getCompletionCount(@NotNull CssCompletionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "getCompletionCount"));
        }
        ProgressManager.checkCanceled();
        assert (!context.isEmpty());
        if (this.isGroup()) {
            CssTableValue.Type type = this.getType();
            int completionCount = 0;
            for (CssPropertyValue each : this.getChildren()) {
                int childCompletionCount;
                int n = childCompletionCount = each.isCompleted(context) ? each.getCompletionCount(context) : 0;
                if (CssTableValue.Type.ANY == type || CssTableValue.Type.DEFAULT == type || CssTableValue.Type.FULL_ANY == type) {
                    if (context.getLength() < this.getMaxCompletionContextLength()) continue;
                    completionCount += childCompletionCount;
                    continue;
                }
                int minCount = this.getMinCount();
                int maxCount = this.getMaxCount();
                if (-1 == minCount && -1 == maxCount) {
                    completionCount = completionCount < childCompletionCount ? childCompletionCount : completionCount;
                    continue;
                }
                if (maxCount == -1) {
                    return 0;
                }
                completionCount += childCompletionCount;
            }
            return completionCount;
        }
        if (context.isCurrent()) {
            return 0;
        }
        int count = 0;
        for (CssCompletionContext c = context; c != null; c = c.getParent()) {
            count += this.isValueBelongs(c.getElement()) ? 1 : 0;
        }
        return count;
    }

    public boolean isCompleted(@NotNull CssCompletionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "isCompleted"));
        }
        ProgressManager.checkCanceled();
        if (context.isEmpty()) {
            return false;
        }
        return !this.isComplete() || this.getCompletionCount(context) >= this.getMaxCompletionContextLength();
    }

    @Nullable
    protected CssTermType getPrefixTermType() {
        String prefix = this.getPrefix();
        if (prefix != null && "$number$".equals(prefix)) {
            return CssTermTypes.NUMBER;
        }
        return null;
    }

    private boolean matchesContext(@NotNull CssCompletionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "matchesContext"));
        }
        return context.matchesTermType(this.getPrefixTermType());
    }

    @NotNull
    protected List<? extends CssPropertyValue> createVariants(@NotNull CssCompletionContext context, PsiElement contextElement) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createVariants"));
        }
        if (context.isEmpty()) {
            List<Object> list = this.isGroup() ? this.getChildren() : this.createValueList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createVariants"));
            }
            return list;
        }
        if (this.isGroup()) {
            switch (this.getType()) {
                case ANY: {
                    List<CssPropertyValue> list = this.createAnyVariants(context, contextElement);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createVariants"));
                    }
                    return list;
                }
                case FULL_ANY: {
                    List<CssPropertyValue> list = this.createAnyVariants(context, contextElement);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createVariants"));
                    }
                    return list;
                }
                case DEFAULT: {
                    List<CssPropertyValue> list = this.createDefaultVariants(context, contextElement);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createVariants"));
                    }
                    return list;
                }
            }
            List<CssPropertyValue> list = this.createOrVariants(context, contextElement);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createVariants"));
            }
            return list;
        }
        List<CssPropertyValue> list = this.createValueList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createVariants"));
        }
        return list;
    }

    @NotNull
    private List<CssPropertyValue> createAnyVariants(@NotNull CssCompletionContext context, PsiElement contextElement) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createAnyVariants"));
        }
        int maxCount = this.getChildren().size();
        int completionCount = this.getCompletionCount(context);
        if (completionCount < maxCount) {
            List<CssPropertyValue> result = this.checkVariants(context, contextElement);
            if (result.isEmpty()) {
                for (CssPropertyValue each : this.getChildren()) {
                    if (each.isCompleted(context)) continue;
                    result.add(each);
                }
            }
            if (result.isEmpty()) {
                for (CssPropertyValue each : this.getChildren()) {
                    result.add(each);
                }
            }
            List<CssPropertyValue> list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createAnyVariants"));
            }
            return list;
        }
        List<CssPropertyValue> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createAnyVariants"));
        }
        return list;
    }

    @NotNull
    private List<CssPropertyValue> createDefaultVariants(@NotNull CssCompletionContext context, PsiElement contextElement) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createDefaultVariants"));
        }
        int maxCount = -1 == this.getMinCount() ? 1 : this.getMaxCount();
        int completionCount = this.getCompletionCount(context);
        if (completionCount < maxCount) {
            ArrayList<CssPropertyValue> result = new ArrayList<CssPropertyValue>();
            for (CssPropertyValue each : this.getChildren()) {
                if (each.isCompleted(context)) continue;
                result.addAll(each.getVariants(context, contextElement));
                break;
            }
            if (result.isEmpty()) {
                for (CssPropertyValue each : this.getChildren()) {
                    result.add(each);
                }
            }
            ArrayList<CssPropertyValue> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createDefaultVariants"));
            }
            return arrayList;
        }
        List<CssPropertyValue> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createDefaultVariants"));
        }
        return list;
    }

    @NotNull
    private List<CssPropertyValue> createOrVariants(@NotNull CssCompletionContext context, PsiElement contextElement) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createOrVariants"));
        }
        int maxCount = this.getMinCount() == -1 ? 1 : (this.getMaxCount() == -1 ? 1 : this.getMaxCount());
        int completionCount = this.getCompletionCount(context);
        if (completionCount < maxCount) {
            List<CssPropertyValue> result = this.checkVariants(context, contextElement);
            if (result.isEmpty()) {
                List<CssPropertyValue> list = this.createValueList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createOrVariants"));
                }
                return list;
            }
            List<CssPropertyValue> list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createOrVariants"));
            }
            return list;
        }
        List<CssPropertyValue> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "createOrVariants"));
        }
        return list;
    }

    private List<CssPropertyValue> checkVariants(CssCompletionContext context, PsiElement contextElement) {
        ArrayList<CssPropertyValue> result = new ArrayList<CssPropertyValue>();
        for (CssPropertyValue each : this.getChildren()) {
            if (each.isCompleted(context) || !context.isCurrent() && !each.isValueBelongs(context.getElement())) continue;
            result.addAll(each.getVariants(context, contextElement));
        }
        return result;
    }

    public boolean isValueBelongs(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        if (this.isGroup()) {
            boolean belongs = false;
            for (CssPropertyValue each : this.getChildren()) {
                belongs |= each.isValueBelongs(element);
            }
            return belongs;
        }
        Object value = this.getValue();
        if (value instanceof String) {
            return ((String)value).equalsIgnoreCase(element.getText());
        }
        return false;
    }

    private List<CssPropertyValue> createValueList() {
        return new ArrayList<CssPropertyValue>(Arrays.asList(this));
    }

    @NotNull
    public List<? extends CssPropertyValue> getVariants(@NotNull CssCompletionContext context, PsiElement contextElement) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "getVariants"));
        }
        List<? extends CssPropertyValue> dynamicVariants = this.getDynamicVariants(contextElement);
        if (!dynamicVariants.isEmpty()) {
            List<? extends CssPropertyValue> list = dynamicVariants;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "getVariants"));
            }
            return list;
        }
        if (this.matchesContext(context) && !this.isCompleted(context)) {
            List<? extends CssPropertyValue> list = this.createVariants(context, contextElement);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "getVariants"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "getVariants"));
        }
        return list;
    }

    @NotNull
    public List<? extends CssPropertyValue> getDynamicVariants(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "getDynamicVariants"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl", "getDynamicVariants"));
        }
        return list;
    }
}

