/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.util.completion.CssUserLookupBase;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssLookupValue
extends CssPropertyValueImpl {
    private final CssTermType[] myTermTypes;

    public CssLookupValue(@NotNull CssUserLookupBase lookup, CssTermType ... termTypes) {
        if (lookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/psi/css/impl/util/table/CssLookupValue", "<init>"));
        }
        if (termTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termTypes", "com/intellij/psi/css/impl/util/table/CssLookupValue", "<init>"));
        }
        super(lookup);
        this.myTermTypes = termTypes;
    }

    public CssLookupValue(@NotNull CssTableValue.Type type, CssTermType ... termTypes) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/util/table/CssLookupValue", "<init>"));
        }
        if (termTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termTypes", "com/intellij/psi/css/impl/util/table/CssLookupValue", "<init>"));
        }
        super(type);
        this.myTermTypes = termTypes;
    }

    @Override
    public boolean isValueBelongs(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        CssTerm term = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)element, CssTerm.class, (boolean)false);
        if (term == null) {
            return false;
        }
        CssTermType cssTermType = term.getTermType();
        for (CssTermType termType : this.myTermTypes) {
            if (termType != cssTermType) continue;
            return true;
        }
        Object value = this.getValue();
        return value != null && value instanceof CssUserLookupBase && ((CssUserLookupBase)this.getValue()).isValidValue(element);
    }
}

