/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPropertyInfo;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.completion.AngleUserLookup;
import com.intellij.psi.css.impl.util.completion.CounterUserLookup;
import com.intellij.psi.css.impl.util.completion.FrequencyUserLookup;
import com.intellij.psi.css.impl.util.completion.IntegerUserLookup;
import com.intellij.psi.css.impl.util.completion.LengthUserLookup;
import com.intellij.psi.css.impl.util.completion.PercentageUserLookup;
import com.intellij.psi.css.impl.util.completion.ResolutionUserLookup;
import com.intellij.psi.css.impl.util.completion.ShapeUserLookup;
import com.intellij.psi.css.impl.util.completion.TimeUserLookup;
import com.intellij.psi.css.impl.util.completion.UriUserLookup;
import com.intellij.psi.css.impl.util.table.CssBorderWidthValue;
import com.intellij.psi.css.impl.util.table.CssColorValue;
import com.intellij.psi.css.impl.util.table.CssExpandedValue;
import com.intellij.psi.css.impl.util.table.CssFontFamilyDescriptor;
import com.intellij.psi.css.impl.util.table.CssFontFamilyValue;
import com.intellij.psi.css.impl.util.table.CssFunctionPropertyValue;
import com.intellij.psi.css.impl.util.table.CssImageValue;
import com.intellij.psi.css.impl.util.table.CssLookupValue;
import com.intellij.psi.css.impl.util.table.CssMarginWidthValue;
import com.intellij.psi.css.impl.util.table.CssPropertyDescriptorImpl;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.impl.util.table.CssReferencePropertyValue;
import com.intellij.psi.css.impl.util.table.CssStringPropertyValue;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.impl.util.table.VoiceFamilyPropertyDescriptor;
import com.intellij.reference.SoftReference;
import gnu.trove.THashMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssElementDescriptorFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.css.impl.util.table.CssElementDescriptorFactory");
    private Reference<Map<String, CssPropertyDescriptor>> myDescriptorMapRef;

    @NotNull
    private synchronized Map<String, CssPropertyDescriptor> getDescriptorsMap() {
        Map<String, CssPropertyDescriptor> descriptors = (Map<String, CssPropertyDescriptor>)SoftReference.dereference(this.myDescriptorMapRef);
        Map<String, CssPropertyDescriptor> map = descriptors != null ? descriptors : this.reload();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "getDescriptorsMap"));
        }
        return map;
    }

    @NotNull
    private synchronized Map<String, CssPropertyDescriptor> reload() {
        THashMap propertiesDescriptionMap = new THashMap();
        CssElementDescriptorFactory.loadDescriptors(CssElementDescriptor.CssVersion.CSS_2_1, (Map<String, List<MyCssPropertyXmlDescription>>)propertiesDescriptionMap);
        CssElementDescriptorFactory.loadDescriptors(CssElementDescriptor.CssVersion.CSS_3_0, (Map<String, List<MyCssPropertyXmlDescription>>)propertiesDescriptionMap);
        CssElementDescriptorFactory.loadDescriptors(CssElementDescriptor.CssVersion.CSS_3_0_MOZILLA, (Map<String, List<MyCssPropertyXmlDescription>>)propertiesDescriptionMap);
        CssElementDescriptorFactory.loadDescriptors(CssElementDescriptor.CssVersion.CSS_3_0_SAFARI, (Map<String, List<MyCssPropertyXmlDescription>>)propertiesDescriptionMap);
        CssElementDescriptorFactory.loadDescriptors(CssElementDescriptor.CssVersion.CSS_3_0_OPERA, (Map<String, List<MyCssPropertyXmlDescription>>)propertiesDescriptionMap);
        Map<String, CssPropertyDescriptor> descriptors = CssElementDescriptorFactory.buildDescriptorsMap((Map<String, List<MyCssPropertyXmlDescription>>)propertiesDescriptionMap);
        this.myDescriptorMapRef = new SoftReference(descriptors);
        Map<String, CssPropertyDescriptor> map = descriptors;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "reload"));
        }
        return map;
    }

    @Nullable
    public static CssPropertyDescriptor getDescriptor(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "getDescriptor"));
        }
        propertyName = propertyName.toLowerCase(Locale.US);
        CssElementDescriptorFactory service = (CssElementDescriptorFactory)ServiceManager.getService(CssElementDescriptorFactory.class);
        if (service == null) {
            return null;
        }
        Map<String, CssPropertyDescriptor> descriptors = service.getDescriptorsMap();
        CssPropertyDescriptor descriptor = descriptors.get(propertyName);
        if (descriptor == null) {
            descriptor = descriptors.get(CssPropertyUtil.getElementNameWithoutVendorPrefix(propertyName));
        }
        if (descriptor == null && propertyName.length() > 1 && CssUtil.isHackPropertyName(propertyName)) {
            descriptor = descriptors.get(propertyName.substring(1));
        }
        return descriptor;
    }

    @NotNull
    private static Map<String, CssPropertyDescriptor> buildDescriptorsMap(@NotNull Map<String, List<MyCssPropertyXmlDescription>> propertiesDescriptionMap) {
        if (propertiesDescriptionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesDescriptionMap", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "buildDescriptorsMap"));
        }
        THashMap result = new THashMap();
        for (String propertyName : propertiesDescriptionMap.keySet()) {
            result.put(propertyName, CssElementDescriptorFactory.createDescriptor(propertyName, propertiesDescriptionMap.get(propertyName)));
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "buildDescriptorsMap"));
        }
        return tHashMap;
    }

    private static void loadDescriptors(@NotNull CssElementDescriptor.CssVersion version, @NotNull Map<String, List<MyCssPropertyXmlDescription>> propertiesDescriptionMap) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "loadDescriptors"));
        }
        if (propertiesDescriptionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesDescriptionMap", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "loadDescriptors"));
        }
        THashMap map = new THashMap();
        CssElementDescriptorFactory.doLoadDescriptors(version, (Map<String, MyCssPropertyXmlDescription>)map);
        for (String propertyName : map.keySet()) {
            MyCssPropertyXmlDescription description = (MyCssPropertyXmlDescription)map.get((Object)propertyName);
            List<MyCssPropertyXmlDescription> descriptionList = propertiesDescriptionMap.get(propertyName);
            if (descriptionList == null) {
                descriptionList = new ArrayList<MyCssPropertyXmlDescription>();
                propertiesDescriptionMap.put(propertyName, descriptionList);
            }
            descriptionList.add(description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doLoadDescriptors(@NotNull CssElementDescriptor.CssVersion version, @NotNull Map<String, MyCssPropertyXmlDescription> propertiesDescriptionMap) {
        String filename;
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "doLoadDescriptors"));
        }
        if (propertiesDescriptionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesDescriptionMap", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "doLoadDescriptors"));
        }
        if (version == CssElementDescriptor.CssVersion.CSS_2_1) {
            filename = "csstable.xml";
        } else if (version == CssElementDescriptor.CssVersion.CSS_3_0) {
            filename = "css3table.xml";
        } else if (version == CssElementDescriptor.CssVersion.CSS_3_0_MOZILLA) {
            filename = "css3mozillatable.xml";
        } else if (version == CssElementDescriptor.CssVersion.CSS_3_0_SAFARI) {
            filename = "css3safaritable.xml";
        } else if (version == CssElementDescriptor.CssVersion.CSS_3_0_OPERA) {
            filename = "css3operatable.xml";
        } else {
            throw new IllegalArgumentException("Unknown CSS version " + version);
        }
        InputStream stream = CssElementDescriptorFactory.class.getResourceAsStream(filename);
        try {
            Element element = JDOMUtil.load((InputStream)stream);
            for (Element each : element.getChildren("property")) {
                ProgressManager.checkCanceled();
                String propertyName = each.getAttributeValue("name");
                assert (propertyName != null);
                propertiesDescriptionMap.put(propertyName, new MyCssPropertyXmlDescription(each, version));
            }
        }
        catch (JDOMException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    @NotNull
    private static CssPropertyDescriptor createDescriptor(@NotNull String propertyName, @NotNull List<MyCssPropertyXmlDescription> descriptions) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "createDescriptor"));
        }
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "createDescriptor"));
        }
        ProgressManager.checkCanceled();
        Element[] elements = new Element[descriptions.size()];
        int n = descriptions.size();
        for (int i = 0; i < n; ++i) {
            Element element = descriptions.get((int)i).myElement;
            List children = element.getChildren();
            assert (children.size() == 1);
            elements[i] = (Element)children.get(0);
        }
        CssPropertyInfo[] infos = new CssPropertyInfo[descriptions.size()];
        for (int i = 0; i < infos.length; ++i) {
            Element e = descriptions.get((int)i).myElement;
            CssElementDescriptor.CssVersion version = descriptions.get((int)i).myVersion;
            infos[i] = new CssPropertyInfo(e, version);
        }
        CssPropertyDescriptorImpl result = "font-family".equals(propertyName) ? new CssFontFamilyDescriptor(propertyName, infos) : ("voice-family".equals(propertyName) ? new VoiceFamilyPropertyDescriptor(propertyName, infos) : new CssPropertyDescriptorImpl(propertyName, infos));
        ((CssPropertyDescriptorImpl)result).setValue(CssElementDescriptorFactory.createValues(propertyName, elements));
        CssPropertyDescriptorImpl cssPropertyDescriptorImpl = result;
        if (cssPropertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "createDescriptor"));
        }
        return cssPropertyDescriptorImpl;
    }

    private static CssPropertyValueImpl createValue(@NotNull String propertyName, @NotNull Element e) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "createValue"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "createValue"));
        }
        String valueType = e.getAttributeValue("vtype");
        if ("alphavalue".equals(valueType)) {
            return new CssLookupValue(new IntegerUserLookup(), CssTermTypes.NUMBER);
        }
        if ("color".equals(valueType)) {
            return new CssColorValue();
        }
        if ("uri".equals(valueType)) {
            return new CssLookupValue(new UriUserLookup(), CssTermTypes.URI);
        }
        if ("percentage".equals(valueType)) {
            return new CssLookupValue(new PercentageUserLookup(), CssTermTypes.PERCENTAGE, CssTermTypes.NEGATIVE_PERCENTAGE);
        }
        if ("length".equals(valueType)) {
            return new CssLookupValue(new LengthUserLookup(), CssTermTypes.LENGTH, CssTermTypes.NUMBER, CssTermTypes.NEGATIVE_NUMBER, CssTermTypes.NEGATIVE_LENGTH);
        }
        if ("ref".equals(valueType)) {
            return new CssReferencePropertyValue();
        }
        if ("border-style".equals(valueType)) {
            return CssExpandedValue.createBorderStyleValue();
        }
        if ("border-width".equals(valueType)) {
            return new CssBorderWidthValue();
        }
        if ("angle".equals(valueType)) {
            return new CssLookupValue(new AngleUserLookup(), CssTermTypes.ANGLE, CssTermTypes.NUMBER);
        }
        if ("resolution".equals(valueType)) {
            return new CssLookupValue(new ResolutionUserLookup(), CssTermTypes.RESOLUTION, CssTermTypes.NUMBER);
        }
        if ("shape".equals(valueType)) {
            return new CssLookupValue(new ShapeUserLookup(), CssTermTypes.RECT, CssTermTypes.LENGTH);
        }
        if ("string".equals(valueType)) {
            return new CssStringPropertyValue(e.getText());
        }
        if ("generic-font-family".equals(valueType)) {
            return CssExpandedValue.createGenericFontFamilyValue();
        }
        if ("font-family".equals(valueType)) {
            return new CssFontFamilyValue();
        }
        if ("absolute-size".equals(valueType)) {
            return CssExpandedValue.createAbsoluteSizeValue();
        }
        if ("relative-size".equals(valueType)) {
            return CssExpandedValue.createRelativeSizeValue();
        }
        if ("frequency".equals(valueType)) {
            return new CssLookupValue(new FrequencyUserLookup(), CssTermTypes.FREQUENCY, CssTermTypes.NUMBER);
        }
        if ("margin-width".equals(valueType)) {
            return new CssMarginWidthValue(true);
        }
        if ("padding-width".equals(valueType)) {
            return new CssMarginWidthValue(false);
        }
        if ("integer".equals(valueType)) {
            return new CssLookupValue(new IntegerUserLookup(), CssTermTypes.NEGATIVE_NUMBER, CssTermTypes.NUMBER);
        }
        if ("counter".equals(valueType)) {
            return new CssLookupValue(new CounterUserLookup(), CssTermTypes.COUNTER);
        }
        if ("time".equals(valueType)) {
            return new CssLookupValue(new TimeUserLookup(), CssTermTypes.TIME);
        }
        if ("identifier".equals(valueType)) {
            return new CssPropertyValueImpl(e.getText()){

                @Override
                public boolean isValueBelongs(@Nullable PsiElement element) {
                    return true;
                }
            };
        }
        if ("overflow".equals(valueType)) {
            return CssExpandedValue.createOverflowValue();
        }
        if ("function".equals(valueType)) {
            String functionName = e.getAttributeValue("function-name");
            assert (functionName != null) : "function name is not specified for property " + propertyName;
            return new CssFunctionPropertyValue(functionName, false);
        }
        if ("optional-function".equals(valueType)) {
            String functionName = e.getAttributeValue("function-name");
            assert (functionName != null) : "function name is not specified for property " + propertyName;
            return new CssFunctionPropertyValue(functionName, true);
        }
        if ("image".equals(valueType)) {
            return new CssImageValue();
        }
        return new CssPropertyValueImpl(e.getText());
    }

    private static CssPropertyValueImpl createValues(@NotNull String propertyName, @NotNull Element[] elements) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "createValues"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "createValues"));
        }
        if (elements.length == 1) {
            return CssElementDescriptorFactory.createValues(propertyName, elements[0], null);
        }
        CssPropertyValueImpl value = new CssPropertyValueImpl("");
        value.setType(CssTableValue.Type.OR);
        for (Element element : elements) {
            CssElementDescriptorFactory.createValues(propertyName, element, value);
        }
        return value;
    }

    private static CssPropertyValueImpl createValues(@NotNull String propertyName, @NotNull Element e, @Nullable CssPropertyValueImpl parent) {
        String refName;
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "createValues"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory", "createValues"));
        }
        CssPropertyValueImpl value = CssElementDescriptorFactory.createValue(propertyName, e);
        value.setComplete(e.getAttributeValue("donotcomplete") == null);
        if (parent != null) {
            parent.addChild(value);
        }
        String min = e.getAttributeValue("min");
        String max = e.getAttributeValue("max");
        String type = e.getAttributeValue("type");
        if (min != null) {
            value.setMinCount(Integer.valueOf(min));
            value.setMaxCount(Integer.valueOf(max));
        }
        if (type != null) {
            value.setType(CssTableValue.Type.valueOf((String)type.toUpperCase(Locale.US)));
        }
        value.setPrefix(e.getAttributeValue("prefix"));
        value.setHasImmutablePrefix(Boolean.valueOf(e.getAttributeValue("immutable-name-prefix")));
        String valuesDelimiter = e.getAttributeValue("values-delimiter");
        if (valuesDelimiter != null) {
            value.setValuesDelimiter(valuesDelimiter);
        }
        if ((refName = e.getAttributeValue("refname")) != null) {
            value.setRefName(refName);
        }
        List children = e.getChildren();
        for (Element child : children) {
            CssElementDescriptorFactory.createValues(propertyName, child, value);
        }
        return value;
    }

    private static class MyCssPropertyXmlDescription {
        final Element myElement;
        final CssElementDescriptor.CssVersion myVersion;

        private MyCssPropertyXmlDescription(@NotNull Element element, @NotNull CssElementDescriptor.CssVersion version) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory$MyCssPropertyXmlDescription", "<init>"));
            }
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory$MyCssPropertyXmlDescription", "<init>"));
            }
            this.myElement = element;
            this.myVersion = version;
        }
    }
}

