/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.scheme;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.value.CssAnyValue;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.CssFunctionDescriptorImpl;
import com.intellij.psi.css.impl.descriptor.value.CssAnyValueImpl;
import com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssNameValue;
import com.intellij.psi.css.impl.descriptor.value.CssNumberValue;
import com.intellij.psi.css.impl.descriptor.value.CssStringValue;
import com.intellij.psi.css.impl.descriptor.value.CssTextValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorData;
import com.intellij.psi.css.impl.util.scheme.CssDescriptorsHolder;
import com.intellij.psi.css.impl.util.scheme.CssDescriptorsLoader;
import com.intellij.psi.css.impl.util.scheme.CssValueDescriptorModificator;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssElementDescriptorFactory2 {
    private static final CssCommonDescriptorData CSS_TOGGLE_FUNCTION_COMMON_DATA = new CssCommonDescriptorData("toggle", "toggle", new CssContextType[]{CssContextType.ANY}, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.CSS_3_0, "http://dev.w3.org/csswg/css-values/#funcdef-toggle", "The toggle() expression allows descendant elements to cycle over a list of values instead of inheriting the same value.");
    private static final CssCommonDescriptorData CSS_VAR_FUNCTION_COMMON_DATA = new CssCommonDescriptorData("var", "var", new CssContextType[]{CssContextType.ANY}, new BrowserVersion[]{new BrowserVersion(BrowserVersion.Browser.CHROME, "49"), new BrowserVersion(BrowserVersion.Browser.SAFARI, "9.1"), new BrowserVersion(BrowserVersion.Browser.FIREFOX, "29")}, CssElementDescriptor.CssVersion.CSS_3_0, "https://www.w3.org/TR/css-variables/#funcdef-var", "The var() function returns the value of a custom property.");
    private static final String[] SCHEME_NAMES = new String[]{"css-cascade-4.xml", "css1.0.xml", "css2.0.xml", "css2.1.xml", "css3.0.xml", "css-overflow-3.xml", "css-box.xml", "css3-gcpm.xml", "css-page-floats.xml", "css3-page.xml", "custom-elements.xml", "css3-images.xml", "css4-images.xml", "css3-line-grid.xml", "css3-mediaqueries.xml", "view-mode.xml", "css3-animations.xml", "css-device-adapt.xml", "css3-transitions.xml", "css3-transforms.xml", "css-text-3.xml", "css-ruby-1.xml", "css3-writing-modes.xml", "css3-speech.xml", "css3-ui.xml", "css-counter-styles-3.xml", "css-lists-3.xml", "css3-filter-effects.xml", "css-scoping1.xml", "css-regions.xml", "css3-break.xml", "css3-flexbox.xml", "css3-grid.xml", "css-masking-1.xml", "css-shapes-1.xml", "css3-background.xml", "css-display-3.xml", "css3-fonts.xml", "fontface.xml", "css-text-decor-3.xml", "css3-preslev.xml", "css3-positioning.xml", "css-compositing-1.xml", "css3-align.xml", "ie.xml", "jquery.xml", "mozilla.xml", "mso.xml", "opera.xml", "svg.xml", "webkit.xml", "css-snappoints-1.xml", "css-will-change.xml", "css-inline-3.xml", "appmanifest.xml", "css-color-4.xml", "css-selectors-4.xml", "cssModules.xml"};
    private final String[] mySchemesToLoad;
    @Nullable
    private final ProgressManager myProgressManager;
    private Reference<CssDescriptorsHolder> myCssDescriptorsHolderRef;

    public static CssElementDescriptorFactory2 getInstance() {
        return (CssElementDescriptorFactory2)ServiceManager.getService(CssElementDescriptorFactory2.class);
    }

    private synchronized CssDescriptorsHolder getDescriptors() {
        CssDescriptorsHolder descriptors = (CssDescriptorsHolder)SoftReference.dereference(this.myCssDescriptorsHolderRef);
        return descriptors != null ? descriptors : this.reload();
    }

    @NotNull
    public Collection<CssPseudoSelectorDescriptor> findPseudoSelector(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "findPseudoSelector"));
        }
        Collection collection = this.getDescriptors().pseudoSelectors.get((Object)name.toLowerCase(Locale.US));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "findPseudoSelector"));
        }
        return collection;
    }

    @NotNull
    public Collection<CssPropertyDescriptor> findProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "findProperty"));
        }
        Collection collection = this.getProperties().get((Object)name.toLowerCase(Locale.US));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "findProperty"));
        }
        return collection;
    }

    @NotNull
    public Collection<CssFunctionDescriptor> findFunction(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "findFunction"));
        }
        Collection collection = this.getDescriptors().functions.get((Object)name.toLowerCase(Locale.US));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "findFunction"));
        }
        return collection;
    }

    @NotNull
    public Collection<CssMediaFeatureDescriptor> findMediaFeature(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "findMediaFeature"));
        }
        Collection collection = this.getDescriptors().mediaFeatures.get((Object)name.toLowerCase(Locale.US));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "findMediaFeature"));
        }
        return collection;
    }

    public Set<String> getAllNamedValues() {
        return this.getDescriptors().namedValues.keySet();
    }

    @NotNull
    public Collection<CssValueDescriptor> findNamedValue(@NotNull String name, @Nullable CssValueDescriptor parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "findNamedValue"));
        }
        if (parent != null) {
            List list = ContainerUtil.map((Collection)this.getDescriptors().namedValues.get((Object)name.toLowerCase(Locale.US)), descriptor -> CssValueDescriptorModificator.withParent(descriptor, parent));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "findNamedValue"));
            }
            return list;
        }
        Collection collection = this.getDescriptors().namedValues.get((Object)name.toLowerCase(Locale.US));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "findNamedValue"));
        }
        return collection;
    }

    @NotNull
    public MultiMap<String, CssPseudoSelectorDescriptor> getPseudoSelectors() {
        MultiMap<String, CssPseudoSelectorDescriptor> multiMap = this.getDescriptors().pseudoSelectors;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "getPseudoSelectors"));
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, CssFunctionDescriptor> getFunctions() {
        MultiMap<String, CssFunctionDescriptor> multiMap = this.getDescriptors().functions;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "getFunctions"));
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, CssPropertyDescriptor> getProperties() {
        MultiMap<String, CssPropertyDescriptor> multiMap = this.getDescriptors().properties;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "getProperties"));
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, CssMediaFeatureDescriptor> getMediaFeatures() {
        MultiMap<String, CssMediaFeatureDescriptor> multiMap = this.getDescriptors().mediaFeatures;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "getMediaFeatures"));
        }
        return multiMap;
    }

    @NotNull
    public Set<String> getValueIdentifiers() {
        Set<String> set = this.getDescriptors().valueIdentifiers;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "getValueIdentifiers"));
        }
        return set;
    }

    @NotNull
    public CssFunctionDescriptor createToggleFunctionDescriptorFromPropertyDescriptor(@NotNull CssPropertyDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "createToggleFunctionDescriptorFromPropertyDescriptor"));
        }
        CssFunctionDescriptorImpl cssFunctionDescriptorImpl = new CssFunctionDescriptorImpl(CSS_TOGGLE_FUNCTION_COMMON_DATA, CssValueDescriptorModificator.withQuantifiers(descriptor.getValueDescriptor(), 1, -1, true), CssTermTypes.TOGGLE);
        if (cssFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "createToggleFunctionDescriptorFromPropertyDescriptor"));
        }
        return cssFunctionDescriptorImpl;
    }

    @NotNull
    public CssFunctionDescriptor createVarFunctionDescriptorFromPropertyDescriptors(@NotNull CssValueDescriptor valueDescriptor) {
        if (valueDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "createVarFunctionDescriptorFromPropertyDescriptors"));
        }
        CssGroupValue value = this.createGroupValue(CssGroupValue.Type.ALL, 1, 1, null, null);
        value.addChild(this.createNameValueDescriptor(null, CssBundle.message((String)"custom.property.name.value.presentable.name", (Object[])new Object[0]), 1, 1, value));
        CssGroupValue defaultValue = this.createGroupValue(CssGroupValue.Type.ALL, 0, 1, value, null);
        defaultValue.addChild(this.createTextValueDescriptor(",", 1, 1, defaultValue));
        defaultValue.addChild(CssValueDescriptorModificator.withParent(valueDescriptor, defaultValue));
        value.addChild(defaultValue);
        CssFunctionDescriptorImpl cssFunctionDescriptorImpl = new CssFunctionDescriptorImpl(CSS_VAR_FUNCTION_COMMON_DATA, value, CssTermTypes.VAR);
        if (cssFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "createVarFunctionDescriptorFromPropertyDescriptors"));
        }
        return cssFunctionDescriptorImpl;
    }

    public CssElementDescriptorFactory2(@Nullable ProgressManager progressManager) {
        this(progressManager, SCHEME_NAMES);
    }

    public CssElementDescriptorFactory2(@Nullable ProgressManager progressManager, String ... schemesToLoad) {
        this.mySchemesToLoad = schemesToLoad;
        this.myProgressManager = progressManager;
    }

    public synchronized CssDescriptorsHolder reload() {
        CssDescriptorsLoader loader = new CssDescriptorsLoader(this.myProgressManager != null ? this.myProgressManager.getProgressIndicator() : null);
        for (String scheme : this.mySchemesToLoad) {
            loader.loadDescriptors(this.getClass().getResource("xml/" + scheme));
        }
        CssDescriptorsHolder descriptors = loader.getDescriptors();
        this.myCssDescriptorsHolderRef = new SoftReference((Object)descriptors);
        return descriptors;
    }

    public CssGroupValue createGroupValue(@NotNull CssGroupValue.Type type, int minOccur, int maxOccur, @Nullable CssValueDescriptor parent, @Nullable CssValueDescriptor separator) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "createGroupValue"));
        }
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData("", "", CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(false, minOccur, maxOccur, null, null, parent, null, false);
        return CssGroupValue.create(commonDescriptorData, valueDescriptorData, true, separator, type);
    }

    public CssTextValue createTextValueDescriptor(@NotNull String text, int minOccur, int maxOccur, CssValueDescriptor parent) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "createTextValueDescriptor"));
        }
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(text, text, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssTextValue(text, commonDescriptorData, valueDescriptorData);
    }

    public CssNameValue createNameValueDescriptor(@Nullable String id, @Nullable String presentableName, int minOccur, int maxOccur, CssValueDescriptor parent) {
        presentableName = StringUtil.notNullize((String)presentableName, (String)CssBundle.message((String)"name.value.presentable.name", (Object[])new Object[0]));
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(presentableName, presentableName, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssNameValue(id, true, commonDescriptorData, valueDescriptorData);
    }

    public CssAnyValue createAnyValueDescriptor(int minOccur, int maxOccur, CssValueDescriptor parent) {
        String id = CssBundle.message((String)"any.value.presentable.name", (Object[])new Object[0]);
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(id, id, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssAnyValueImpl(commonDescriptorData, valueDescriptorData);
    }

    public CssNumberValue createNumberValueDescriptor(int minOccur, int maxOccur, CssValueDescriptor parent) {
        String id = CssBundle.message((String)"number.value.presentable.name", (Object[])new Object[0]);
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(id, id, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssNumberValue(commonDescriptorData, valueDescriptorData);
    }

    public CssStringValue createStringValueDescriptor(@Nullable String stringValue, int minOccur, int maxOccur, CssValueDescriptor parent) {
        String id = stringValue != null ? StringUtil.wrapWithDoubleQuote((String)stringValue) : CssBundle.message((String)"string.value.presentable.name", (Object[])new Object[0]);
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(id, id, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssStringValue(stringValue, commonDescriptorData, valueDescriptorData);
    }

    public CssFunctionInvocationValue createFunctionInvocationValueDescriptor(@NotNull String name, int minOccur, int maxOccur, CssValueDescriptor parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2", "createFunctionInvocationValueDescriptor"));
        }
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(name, name, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssFunctionInvocationValue(name, commonDescriptorData, valueDescriptorData);
    }
}

