/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class CssHexColorsFormatPreprocessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/editor/CssHexColorsFormatPreprocessor", "process"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/css/impl/util/editor/CssHexColorsFormatPreprocessor", "process"));
        }
        PsiElement psiElement = element.getPsi();
        if (psiElement == null || !psiElement.isValid()) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssHexColorsFormatPreprocessor", "process"));
            }
            return textRange;
        }
        if (!psiElement.getLanguage().isKindOf((Language)CSSLanguage.INSTANCE) && !CssSupportLoader.isInFileThatSupportsEmbeddedCss(psiElement)) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssHexColorsFormatPreprocessor", "process"));
            }
            return textRange;
        }
        TextRange textRange = new CssHexColorsFormatter(psiElement).process(range);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssHexColorsFormatPreprocessor", "process"));
        }
        return textRange;
    }

    private static class CssHexColorsFormatter
    extends CssElementVisitor {
        private Project myProject;
        private PsiElement myElement;
        private PsiDocumentManager myDocumentManager;
        private Document myDocument;
        private CssCodeStyleSettings myCssFormattingSettings;
        private TextRange myRange;
        private TextRange myOrigRange;
        private int myDelta = 0;

        public CssHexColorsFormatter(PsiElement element) {
            try {
                this.myProject = element.getProject();
                this.myElement = element;
                PsiFile file = element.getContainingFile();
                this.myDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                this.myDocument = this.myDocumentManager.getDocument(file);
                this.myCssFormattingSettings = (CssCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(CssCodeStyleSettings.class);
            }
            catch (PsiInvalidElementAccessException e) {
                this.myProject = null;
            }
        }

        public TextRange process(TextRange range) {
            if (this.myProject == null) {
                return range;
            }
            if (this.myDocument == null || !this.myCssFormattingSettings.HEX_COLOR_UPPER_CASE && !this.myCssFormattingSettings.HEX_COLOR_LOWER_CASE && !this.myCssFormattingSettings.HEX_COLOR_LONG_FORMAT && !this.myCssFormattingSettings.HEX_COLOR_SHORT_FORMAT) {
                return range;
            }
            this.myOrigRange = range;
            this.myRange = TextRange.create((int)range.getStartOffset(), (int)range.getEndOffset());
            this.myDocumentManager.doPostponedOperationsAndUnblockDocument(this.myDocument);
            this.myElement.accept((PsiElementVisitor)this);
            this.myDocumentManager.commitDocument(this.myDocument);
            return this.myRange;
        }

        public void visitCssTerm(CssTerm _term) {
            TextRange textRange = _term.getTextRange();
            if (this.myOrigRange.contains(textRange) && _term.getTermType() == CssTermTypes.COLOR) {
                String text = _term.getText();
                String replacementText = null;
                if (StringUtil.startsWithChar((CharSequence)text, (char)'#')) {
                    if (this.myCssFormattingSettings.HEX_COLOR_LONG_FORMAT && text.length() == 4) {
                        replacementText = CssPsiColorUtil.normalizeHexColor(text);
                    } else if (this.myCssFormattingSettings.HEX_COLOR_SHORT_FORMAT && text.length() == 7) {
                        replacementText = CssPsiColorUtil.toShortHexColor(text);
                    }
                    if (this.myCssFormattingSettings.HEX_COLOR_UPPER_CASE) {
                        replacementText = replacementText != null ? replacementText.toUpperCase(Locale.US) : text.toUpperCase(Locale.US);
                    } else if (this.myCssFormattingSettings.HEX_COLOR_LOWER_CASE) {
                        String string = replacementText = replacementText != null ? replacementText.toLowerCase(Locale.US) : text.toLowerCase(Locale.US);
                    }
                    if (replacementText != null && !text.equals(replacementText)) {
                        int delta = replacementText.length() - text.length();
                        int myRangeLength = this.myRange.getLength();
                        if (delta > 0 || myRangeLength - delta > 0) {
                            this.myRange = TextRange.from((int)this.myRange.getStartOffset(), (int)(myRangeLength + delta));
                            this.myDocument.replaceString(textRange.getStartOffset() + this.myDelta, textRange.getEndOffset() + this.myDelta, (CharSequence)replacementText);
                            this.myDelta += delta;
                        }
                    }
                }
            } else {
                this.visitElement((PsiElement)_term);
            }
        }

        public void visitElement(PsiElement element) {
            element.acceptChildren((PsiElementVisitor)this);
        }
    }
}

