/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.impl.util.completion.handler.CssPropertyValueInsertHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssUserLookupBase {
    @NotNull
    private final String myPresentableText;

    protected CssUserLookupBase(@NotNull String presentableText) {
        if (presentableText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableText", "com/intellij/psi/css/impl/util/completion/CssUserLookupBase", "<init>"));
        }
        this.myPresentableText = presentableText;
    }

    public LookupElement lookup() {
        return new LiveTemplateLookupElementImpl(this.createTemplate(), false){

            public AutoCompletionPolicy getAutoCompletionPolicy() {
                return AutoCompletionPolicy.SETTINGS_DEPENDENT;
            }

            public void handleInsert(InsertionContext context) {
                super.handleInsert(context);
                CssPropertyValueInsertHandler.INSTANCE.handleInsert(context, (LookupElement)this);
            }
        };
    }

    protected TemplateImpl createTemplate() {
        TemplateImpl template = new TemplateImpl(this.myPresentableText, "css_value_group");
        this.addAdditionalVariablesBefore((Template)template);
        TextExpression expression = new TextExpression(this.getDefaultValue());
        template.addVariable(this.myPresentableText, (Expression)expression, (Expression)expression, true);
        String suffix = this.getSuffix();
        if (StringUtil.isNotEmpty((String)suffix)) {
            template.addTextSegment(suffix);
        }
        this.addAdditionalVariablesAfter((Template)template);
        return template;
    }

    protected void addAdditionalVariablesBefore(Template template) {
    }

    protected void addAdditionalVariablesAfter(Template template) {
    }

    @NotNull
    protected String getDefaultValue() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/CssUserLookupBase", "getDefaultValue"));
        }
        return "";
    }

    @Nullable
    public String getSuffix() {
        return null;
    }

    public boolean isValidValue(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/completion/CssUserLookupBase", "isValidValue"));
        }
        return false;
    }

    public String toString() {
        return this.myPresentableText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

