/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor.value;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorBase;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorData;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorVisitorImpl;
import org.jetbrains.annotations.NotNull;

public class CssPropertyReferenceValue
extends CssValueDescriptorBase {
    @NotNull
    private final String myPropertyName;

    public CssPropertyReferenceValue(@NotNull String propertyName, @NotNull CssCommonDescriptorData commonDescriptorData, @NotNull CssValueDescriptorData valueDescriptorData) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/descriptor/value/CssPropertyReferenceValue", "<init>"));
        }
        if (commonDescriptorData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonDescriptorData", "com/intellij/psi/css/impl/descriptor/value/CssPropertyReferenceValue", "<init>"));
        }
        if (valueDescriptorData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptorData", "com/intellij/psi/css/impl/descriptor/value/CssPropertyReferenceValue", "<init>"));
        }
        super(commonDescriptorData, valueDescriptorData);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)propertyName) ? 1 : 0) != 0);
        this.myPropertyName = propertyName;
    }

    @NotNull
    public String getPropertyName() {
        String string = this.myPropertyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssPropertyReferenceValue", "getPropertyName"));
        }
        return string;
    }

    @Override
    public void accept(CssValueDescriptorVisitor visitor) {
        if (visitor instanceof CssValueDescriptorVisitorImpl) {
            ((CssValueDescriptorVisitorImpl)visitor).visitPropertyReferenceValue(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CssPropertyReferenceValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CssPropertyReferenceValue value = (CssPropertyReferenceValue)o;
        return this.myPropertyName.equals(value.myPropertyName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myPropertyName.hashCode();
        return result;
    }
}

