/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.descriptor.CssValueOwnerDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.CssElementDescriptorBase;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorVisitorImpl;
import com.intellij.psi.css.impl.descriptor.visitor.CssParameterInfoValueDescriptorsVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssValueOwnerDescriptorImpl
extends CssElementDescriptorBase
implements CssValueOwnerDescriptor {
    @NotNull
    private final CssValueDescriptor myValueDescriptor;

    protected CssValueOwnerDescriptorImpl(@NotNull CssCommonDescriptorData commonDescriptorData, @NotNull CssValueDescriptor valueDescriptor) {
        if (commonDescriptorData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonDescriptorData", "com/intellij/psi/css/impl/descriptor/CssValueOwnerDescriptorImpl", "<init>"));
        }
        if (valueDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "com/intellij/psi/css/impl/descriptor/CssValueOwnerDescriptorImpl", "<init>"));
        }
        super(commonDescriptorData);
        this.myValueDescriptor = valueDescriptor;
    }

    @NotNull
    public CssValueDescriptor getValueDescriptor() {
        CssValueDescriptor cssValueDescriptor = this.myValueDescriptor;
        if (cssValueDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssValueOwnerDescriptorImpl", "getValueDescriptor"));
        }
        return cssValueDescriptor;
    }

    @Override
    @NotNull
    public String getDocumentationString(@Nullable PsiElement context) {
        StringBuilder builder = new StringBuilder(StringUtil.notNullize((String)super.getDocumentationString(context))).append("<br/><p>");
        builder.append("<b>Values:</b><br/>");
        CssParameterInfoValueDescriptorsVisitor parameterInfoBuilder = new CssParameterInfoValueDescriptorsVisitor(null, true, true);
        this.myValueDescriptor.accept((CssValueDescriptorVisitor)parameterInfoBuilder);
        builder.append(parameterInfoBuilder.getParameterInfo()).append("<br/>");
        CssValueOwnerDescriptorImpl.printValueDescription(this.myValueDescriptor, builder);
        String string = builder.append("</p>").toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssValueOwnerDescriptorImpl", "getDocumentationString"));
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CssValueOwnerDescriptorImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CssValueOwnerDescriptorImpl that = (CssValueOwnerDescriptorImpl)o;
        return this.myValueDescriptor.equals(that.myValueDescriptor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myValueDescriptor.hashCode();
        return result;
    }

    private static void printValueDescription(@NotNull CssValueDescriptor descriptor, final @NotNull StringBuilder builder) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/descriptor/CssValueOwnerDescriptorImpl", "printValueDescription"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/psi/css/impl/descriptor/CssValueOwnerDescriptorImpl", "printValueDescription"));
        }
        descriptor.accept((CssValueDescriptorVisitor)new CssValueDescriptorVisitorImpl(){

            @Override
            public void visitGroupValue(@NotNull CssGroupValue groupValue) {
                if (groupValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupValue", "com/intellij/psi/css/impl/descriptor/CssValueOwnerDescriptorImpl$1", "visitGroupValue"));
                }
                this.visitValue(groupValue);
                groupValue.acceptChildren(this);
            }

            @Override
            public void visitValue(@NotNull CssValueDescriptor value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/descriptor/CssValueOwnerDescriptorImpl$1", "visitValue"));
                }
                String description = value.getDescription();
                if (!description.isEmpty()) {
                    builder.append("<br/><i>").append(StringUtil.escapeXml((String)value.getPresentableName())).append("</i> &mdash; ").append(description);
                }
            }
        });
    }
}

