/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.css.util.CssConstants;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.util.CssSuffixes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.xml.util.ColorMap;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssTermImpl
extends CssElementImpl
implements CssTerm {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.css.impl.CssTermImpl");
    @NonNls
    private static final Set<String> LENGTH_SUFFIXES = CssTermImpl.toLowerCase(CssSuffixes.LENGTH_SUFFIXES);
    @NonNls
    private static final Set<String> RESOLUTION_SUFFIXES = CssTermImpl.toLowerCase(CssSuffixes.RESOLUTION_SUFFIXES);
    @NonNls
    private static final Set<String> FREQUENCY_SUFFIXES = CssTermImpl.toLowerCase(CssSuffixes.FREQUENCY_SUFFIXES);
    @NonNls
    private static final Set<String> TIME_SUFFIXES = CssTermImpl.toLowerCase(CssSuffixes.TIME_SUFFIXES);
    @NonNls
    private static final Set<String> ANGLE_SUFFIXES = CssTermImpl.toLowerCase(CssSuffixes.ANGLE_SUFFIXES);
    private volatile CssTermType myTermType;

    public CssTermImpl() {
        super(CssElementTypes.CSS_TERM);
    }

    private static Set<String> toLowerCase(String ... strings) {
        HashSet result = new HashSet(strings.length);
        for (String str : strings) {
            result.add(str.toLowerCase(Locale.US));
        }
        return result;
    }

    @NotNull
    public CssTermType getTermType() {
        CssTermType type = this.myTermType;
        if (type == null) {
            this.myTermType = type = this._calcTermType();
        }
        if (type == null) {
            LOG.info(String.format("Unknown CSS Term: %s", this.getText()));
            this.myTermType = type = CssTermTypes.IDENT;
        }
        CssTermType cssTermType = type;
        if (cssTermType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssTermImpl", "getTermType"));
        }
        return cssTermType;
    }

    public void clearCaches() {
        this.myTermType = null;
        super.clearCaches();
    }

    private CssTermType _calcTermType() {
        ASTNode astNode;
        CssTerm term = (CssTerm)CompletionUtilCoreImpl.getOriginalElement((PsiElement)this);
        term = term == null ? this : term;
        PsiElement parent = term.getParent();
        PsiElement child = term.getFirstChild();
        if (child != null && child.getNode().getElementType() == CssElementTypes.CSS_PLUS) {
            child = child.getNextSibling();
        }
        if (child != null && (astNode = child.getNode()) != null) {
            boolean afterMinus;
            IElementType type = astNode.getElementType();
            ASTNode firstTreeChild = astNode.getFirstChildNode();
            ASTNode lastTreeChild = astNode.getLastChildNode();
            PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)child);
            boolean bl = afterMinus = parent instanceof CssTerm && prevLeaf != null && prevLeaf.getNode().getElementType() == CssElementTypes.CSS_MINUS;
            if (!afterMinus && CssElementTypes.CSS_NUMBER_TERM == type) {
                if (CssElementTypes.CSS_NUMBER == firstTreeChild.getElementType()) {
                    if (firstTreeChild == lastTreeChild) {
                        return CssTermTypes.NUMBER;
                    }
                    if (CssElementTypes.CSS_IDENT == lastTreeChild.getElementType()) {
                        CssTermType suffixType = CssTermImpl.getTypeBySuffix(lastTreeChild.getText());
                        return suffixType == CssTermType.UNKNOWN ? CssTermTypes.NUMBER_WITH_UNKNOWN_UNIT : suffixType;
                    }
                    if (CssElementTypes.CSS_PERCENT == lastTreeChild.getElementType()) {
                        return CssTermTypes.PERCENTAGE;
                    }
                }
            } else if (afterMinus || CssElementTypes.CSS_MINUS == type) {
                ASTNode lastNumberTermNode;
                ASTNode node;
                CssTermImpl numberTerm;
                CssTermImpl cssTermImpl = numberTerm = afterMinus ? this : child.getNextSibling();
                if (numberTerm instanceof CssTerm) {
                    numberTerm = numberTerm.getFirstChild();
                }
                if (numberTerm != null && (node = numberTerm.getNode()) != null && CssElementTypes.CSS_NUMBER_TERM == node.getElementType() && (lastNumberTermNode = node.getLastChildNode()) != null) {
                    if (CssElementTypes.CSS_IDENT == lastNumberTermNode.getElementType()) {
                        String lengthSuffixText = lastNumberTermNode.getText().toLowerCase(Locale.US);
                        if (LENGTH_SUFFIXES.contains(lengthSuffixText)) {
                            return CssTermTypes.NEGATIVE_LENGTH;
                        }
                        if (ANGLE_SUFFIXES.contains(lengthSuffixText)) {
                            return CssTermTypes.NEGATIVE_ANGLE;
                        }
                        String suffixText = lastNumberTermNode.getText().toLowerCase(Locale.US);
                        CssTermType suffixType = CssTermImpl.getTypeBySuffix(suffixText);
                        return suffixType == CssTermType.UNKNOWN ? CssTermTypes.NUMBER_WITH_UNKNOWN_UNIT : suffixType;
                    }
                    if (CssElementTypes.CSS_PERCENT == lastNumberTermNode.getElementType()) {
                        return CssTermTypes.NEGATIVE_PERCENTAGE;
                    }
                    if (CssElementTypes.CSS_NUMBER == lastNumberTermNode.getElementType()) {
                        return CssTermTypes.NEGATIVE_NUMBER;
                    }
                }
            } else {
                String colorName;
                if (CssElementTypes.CSS_HASH == type) {
                    return this.matchHashColor() ? CssTermTypes.COLOR : CssTermTypes.IDENT;
                }
                if (CssElementTypes.CSS_UNICODE_RANGE == type) {
                    return CssTermTypes.UNICODE_RANGE;
                }
                if (child instanceof CssFunction) {
                    if (CssElementTypes.CSS_FUNCTION_TOKEN == firstTreeChild.getElementType()) {
                        String text = firstTreeChild.getText();
                        if (CssConstants.COLOR_FUNCTIONS.contains(text.toLowerCase())) {
                            return CssTermTypes.COLOR;
                        }
                        if ("rect".equalsIgnoreCase(text)) {
                            return CssTermTypes.RECT;
                        }
                        if ("counter".equalsIgnoreCase(text)) {
                            return CssTermTypes.COUNTER;
                        }
                        if ("var".equalsIgnoreCase(text)) {
                            return CssTermTypes.VAR;
                        }
                    }
                    return ((CssFunction)child).getType();
                }
                if (parent != null && parent.getNode().getElementType() == CssElementTypes.CSS_URI && type == CssElementTypes.CSS_STRING) {
                    return CssTermTypes.URI;
                }
                if (CssElementTypes.CSS_STRING == type) {
                    return CssTermTypes.STRING;
                }
                if (CssElementTypes.CSS_URI == type) {
                    return CssTermTypes.URI;
                }
                if (CssElementTypes.CSS_IDENT == type && (ColorMap.getHexCodeForColorName((String)(colorName = this.getText().toLowerCase(Locale.US))) != null || ColorMap.isSystemColorName((String)colorName))) {
                    return CssTermTypes.COLOR;
                }
            }
        }
        return CssTermTypes.IDENT;
    }

    @NotNull
    public static CssTermType getTypeBySuffix(@NotNull String suffixText) {
        if (suffixText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffixText", "com/intellij/psi/css/impl/CssTermImpl", "getTypeBySuffix"));
        }
        if ("fr".equalsIgnoreCase(suffixText = suffixText.toLowerCase(Locale.US))) {
            CssTermType cssTermType = CssTermTypes.FLEX;
            if (cssTermType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssTermImpl", "getTypeBySuffix"));
            }
            return cssTermType;
        }
        if (LENGTH_SUFFIXES.contains(suffixText)) {
            CssTermType cssTermType = CssTermTypes.LENGTH;
            if (cssTermType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssTermImpl", "getTypeBySuffix"));
            }
            return cssTermType;
        }
        if (FREQUENCY_SUFFIXES.contains(suffixText)) {
            CssTermType cssTermType = CssTermTypes.FREQUENCY;
            if (cssTermType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssTermImpl", "getTypeBySuffix"));
            }
            return cssTermType;
        }
        if (TIME_SUFFIXES.contains(suffixText)) {
            CssTermType cssTermType = CssTermTypes.TIME;
            if (cssTermType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssTermImpl", "getTypeBySuffix"));
            }
            return cssTermType;
        }
        if (RESOLUTION_SUFFIXES.contains(suffixText)) {
            CssTermType cssTermType = CssTermTypes.RESOLUTION;
            if (cssTermType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssTermImpl", "getTypeBySuffix"));
            }
            return cssTermType;
        }
        if (ANGLE_SUFFIXES.contains(suffixText)) {
            CssTermType cssTermType = CssTermTypes.ANGLE;
            if (cssTermType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssTermImpl", "getTypeBySuffix"));
            }
            return cssTermType;
        }
        if ("dB".equalsIgnoreCase(suffixText)) {
            CssTermType cssTermType = CssTermTypes.DECIBEL;
            if (cssTermType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssTermImpl", "getTypeBySuffix"));
            }
            return cssTermType;
        }
        if ("st".equalsIgnoreCase(suffixText)) {
            CssTermType cssTermType = CssTermTypes.SEMITONES;
            if (cssTermType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssTermImpl", "getTypeBySuffix"));
            }
            return cssTermType;
        }
        CssTermType cssTermType = CssTermType.UNKNOWN;
        if (cssTermType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssTermImpl", "getTypeBySuffix"));
        }
        return cssTermType;
    }

    private boolean matchHashColor() {
        String s = this.getText().toLowerCase(Locale.US);
        return s.matches("#([0-9a-f]{3}|[0-9a-f]{4}|[0-9a-f]{6}|[0-9a-f]{8})$");
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssTermImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssTerm((CssTerm)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

