/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.psi.css.CssMediaQuery;
import com.intellij.psi.css.CssMediumList;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class CssMediumListImpl
extends CssElementImpl
implements CssMediumList {
    CssMediumListImpl() {
        super(CssElementTypes.CSS_MEDIUM_LIST);
    }

    @NotNull
    public CssMediaQuery[] getMediaQueries() {
        CssMediaQuery[] cssMediaQueryArray = (CssMediaQuery[])this.getChildrenAsPsiElements(CssElementTypes.CSS_MEDIA_QUERY, CssMediaQuery.ARRAY_FACTORY);
        if (cssMediaQueryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssMediumListImpl", "getMediaQueries"));
        }
        return cssMediaQueryArray;
    }

    @NotNull
    public Set<CssMediaType> getTypes() {
        CssMediaQuery[] elements;
        HashSet result = ContainerUtil.newHashSet();
        for (CssMediaQuery element : elements = this.getMediaQueries()) {
            CssMediaType mediaType = element.getMediaType();
            if (mediaType == null) continue;
            result.add(mediaType);
        }
        if (result.isEmpty()) {
            result.add(CssMediaType.SCREEN);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssMediumListImpl", "getTypes"));
        }
        return hashSet;
    }
}

