/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.browse;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.browse.BrowseCssStylesPanel;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.xml.util.HtmlUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BrowseCssStylesManager
extends ContentManagerAdapter {
    @NonNls
    private static final String CSS_BROWSE_STYLES_TOOLWINDOW = "CSS Styles";
    private final ToolWindowManager myToolWindowManager;
    private ToolWindow myToolWindow;
    private final CssResolver myResolver;

    public BrowseCssStylesManager(@NotNull ToolWindowManager toolWindowManager) {
        if (toolWindowManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/intellij/psi/css/browse/BrowseCssStylesManager", "<init>"));
        }
        this.myToolWindowManager = toolWindowManager;
        this.myResolver = CssResolveManager.getInstance().getNewResolver();
        this.myResolver.setUseAgentStylesheet(false);
    }

    public static BrowseCssStylesManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/browse/BrowseCssStylesManager", "getInstance"));
        }
        return (BrowseCssStylesManager)((Object)ServiceManager.getService((Project)project, BrowseCssStylesManager.class));
    }

    public void addStylesTab(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/browse/BrowseCssStylesManager", "addStylesTab"));
        }
        ToolWindow toolWindow = this.getToolWindow();
        ContentManager contentManager = toolWindow.getContentManager();
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content c = contentFactory.createContent((JComponent)new BrowseCssStylesPanel(tag, this.myResolver), BrowseCssStylesManager.getContentName(tag), true);
        contentManager.addContent(c);
        contentManager.setSelectedContent(c);
        toolWindow.activate(null);
    }

    public void removeStylesTab(@NotNull JComponent c) {
        ContentManager contentManager;
        Content content;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/psi/css/browse/BrowseCssStylesManager", "removeStylesTab"));
        }
        if (this.myToolWindow != null && (content = (contentManager = this.myToolWindow.getContentManager()).getContent(c)) != null) {
            contentManager.removeContent(content, true);
        }
    }

    private static String getContentName(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/browse/BrowseCssStylesManager", "getContentName"));
        }
        String formattedTag = HtmlUtil.getTagPresentation((XmlTag)tag);
        PsiFile file = tag.getContainingFile();
        if (file != null) {
            return SymbolPresentationUtil.getFilePathPresentation((PsiFile)file) + ":" + formattedTag;
        }
        return formattedTag;
    }

    @NotNull
    private ToolWindow getToolWindow() {
        if (this.myToolWindow == null) {
            this.myToolWindow = this.myToolWindowManager.registerToolWindow(CSS_BROWSE_STYLES_TOOLWINDOW, true, ToolWindowAnchor.BOTTOM);
            this.myToolWindow.getContentManager().addContentManagerListener((ContentManagerListener)this);
            this.myToolWindow.setIcon(AllIcons.Css.Toolwindow);
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/browse/BrowseCssStylesManager", "getToolWindow"));
        }
        return toolWindow;
    }

    public void contentRemoved(ContentManagerEvent event) {
        ContentManager contentManager;
        if (this.myToolWindow != null && (contentManager = this.myToolWindow.getContentManager()).getContentCount() == 0) {
            this.myToolWindowManager.unregisterToolWindow(CSS_BROWSE_STYLES_TOOLWINDOW);
            contentManager.removeContentManagerListener((ContentManagerListener)this);
            this.myToolWindow = null;
        }
    }
}

