/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssElementDescriptorConstants;
import com.intellij.psi.css.inspections.bugs.CssNoGenericFontNameInspection;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssInsertGenericFontFamilyIntention
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public CssInsertGenericFontFamilyIntention(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention", "<init>"));
        }
        super((PsiElement)declaration);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        CssDeclaration cssDeclaration;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention", "isAvailable"));
        }
        if (startElement instanceof CssDeclaration && (cssDeclaration = (CssDeclaration)startElement).isValid()) {
            String propertyName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)cssDeclaration);
            return "font-family".equals(propertyName) && CssNoGenericFontNameInspection.isGenericFontFamilyMissed(cssDeclaration);
        }
        return false;
    }

    private static int findPlaceForGenericFontName(@NotNull CssDeclaration declaration) {
        PsiElement[] terms;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention", "findPlaceForGenericFontName"));
        }
        CssTermList termList = declaration.getValue();
        if (termList != null && (terms = termList.getChildren()).length > 0) {
            return terms[terms.length - 1].getTextRange().getEndOffset();
        }
        return declaration.getTextRange().getEndOffset();
    }

    private static Template createTemplate(Project project, boolean withComma) {
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "");
        template.addTextSegment(withComma ? "," : "");
        final TextResult defaultText = new TextResult("serif");
        final LookupElement[] lookupItems = (LookupElement[])ContainerUtil.map2Array(CssElementDescriptorConstants.GENERIC_FONT_NAMES, LookupElement.class, s -> LookupElementBuilder.create((String)s));
        Expression expression = new Expression(){

            public com.intellij.codeInsight.template.Result calculateResult(ExpressionContext context) {
                return defaultText;
            }

            public com.intellij.codeInsight.template.Result calculateQuickResult(ExpressionContext context) {
                return null;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return lookupItems;
            }
        };
        template.addVariable("name", expression, expression, true);
        return template;
    }

    public void invoke(final @NotNull Project project, @NotNull PsiFile file, final @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention", "invoke"));
        }
        if (editor == null || !(startElement instanceof CssDeclaration)) {
            return;
        }
        final CssDeclaration cssDeclaration = (CssDeclaration)startElement;
        CssTermList value = cssDeclaration.getValue();
        if (value == null) {
            return;
        }
        CssTerm[] terms = value.getTerms();
        final Template template = CssInsertGenericFontFamilyIntention.createTemplate(project, terms.length > 0);
        PsiFile containingFile = cssDeclaration.getContainingFile();
        if (containingFile != null) {
            new WriteCommandAction(project, new PsiFile[]{containingFile}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention$2", "run"));
                    }
                    int offset = CssInsertGenericFontFamilyIntention.findPlaceForGenericFontName(cssDeclaration);
                    editor.getCaretModel().moveToOffset(offset);
                    CodeEditUtil.markToReformat((ASTNode)cssDeclaration.getNode(), (boolean)true);
                    TemplateManager.getInstance((Project)project).startTemplate(editor, template);
                }
            }.execute();
        }
    }

    @NotNull
    public String getText() {
        String string = CssBundle.message((String)"css.overwritten.nongeneric.fontname.fix.message", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention", "getText"));
        }
        return string;
    }
}

