/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.settings;

import com.intellij.lang.PerFileMappings;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.tree.LanguagePerFileConfigurable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssDialectsConfigurable
extends LanguagePerFileConfigurable<CssDialect> {
    static final String ID = "settings.css.dialects";

    public CssDialectsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/settings/CssDialectsConfigurable", "<init>"));
        }
        super(project, CssDialect.class, (PerFileMappings)CssDialectMappings.getInstance(project), CssBundle.message((String)"css.dialects.caption", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), CssBundle.message((String)"css.dialects.column.title", (Object[])new Object[0]), CssBundle.message((String)"css.dialects.override.warning.text", (Object[])new Object[0]), CssBundle.message((String)"css.dialects.override.warning.title", (Object[])new Object[0]));
    }

    @Nls
    public String getDisplayName() {
        return CssBundle.message((String)"css.dialects.title", (Object[])new Object[0]);
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/settings/CssDialectsConfigurable", "getId"));
        }
        return ID;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    protected String visualize(@NotNull CssDialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/css/settings/CssDialectsConfigurable", "visualize"));
        }
        return dialect.getDisplayName();
    }

    protected boolean handleDefaultValue(VirtualFile file, ColoredTableCellRenderer renderer) {
        CssDialect t = (CssDialect)this.getNewMapping(file);
        if (t != null) {
            renderer.append(this.visualize(t), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
        return t != null;
    }
}

