/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.configuration;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.intellij.codeInsight.template.emmet.configuration.CssPrefixInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CssEmmetOptions", storages={@Storage(value="emmet.xml")})
public class CssEmmetOptions
implements PersistentStateComponent<CssEmmetOptions> {
    private boolean myCssEmmetEnabled = true;
    private boolean myFuzzySearchEnabled = true;
    private boolean myAutoInsertCssPrefixedEnabled = true;
    private boolean myUnknownPropertiesExpansionEnabled = false;
    @NotNull
    private Map<String, Integer> prefixes = ContainerUtil.newHashMap();

    public boolean isCssEmmetEnabled() {
        return this.myCssEmmetEnabled;
    }

    public void setCssEmmetEnabled(boolean cssEmmetEnabled) {
        this.myCssEmmetEnabled = cssEmmetEnabled;
    }

    public boolean isFuzzySearchEnabled() {
        return this.myFuzzySearchEnabled;
    }

    public void setFuzzySearchEnabled(boolean fuzzySearchEnabled) {
        this.myFuzzySearchEnabled = fuzzySearchEnabled;
    }

    public boolean isAutoInsertCssPrefixedEnabled() {
        return this.myAutoInsertCssPrefixedEnabled;
    }

    public void setAutoInsertCssPrefixedEnabled(boolean autoInsertCssPrefixedEnabled) {
        this.myAutoInsertCssPrefixedEnabled = autoInsertCssPrefixedEnabled;
    }

    public void setPrefixInfo(Collection<CssPrefixInfo> prefixInfos) {
        this.prefixes = Maps.newHashMap();
        for (CssPrefixInfo state : prefixInfos) {
            this.prefixes.put(state.getPropertyName(), state.toIntegerValue());
        }
    }

    public CssPrefixInfo getPrefixStateForProperty(String propertyName) {
        return CssPrefixInfo.fromIntegerValue(propertyName, this.getPrefixes().get(propertyName));
    }

    public Set<CssPrefixInfo> getAllPrefixInfo() {
        HashSet result = Sets.newHashSetWithExpectedSize((int)this.getPrefixes().size());
        for (Map.Entry<String, Integer> entry : this.getPrefixes().entrySet()) {
            result.add(CssPrefixInfo.fromIntegerValue(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    @NotNull
    public Map<String, Integer> getPrefixes() {
        if (this.prefixes.isEmpty()) {
            this.prefixes = CssEmmetOptions.loadDefaultPrefixes();
        }
        Map<String, Integer> map = this.prefixes;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/configuration/CssEmmetOptions", "getPrefixes"));
        }
        return map;
    }

    public void setPrefixes(@NotNull Map<String, Integer> prefixes) {
        if (prefixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixes", "com/intellij/codeInsight/template/emmet/configuration/CssEmmetOptions", "setPrefixes"));
        }
        this.prefixes = prefixes;
    }

    @Nullable
    public CssEmmetOptions getState() {
        return this;
    }

    public void loadState(CssEmmetOptions state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public static CssEmmetOptions getInstance() {
        return (CssEmmetOptions)ServiceManager.getService(CssEmmetOptions.class);
    }

    private static Map<String, Integer> loadDefaultPrefixes() {
        HashMap result = Maps.newHashMap();
        try {
            Document document = JDOMUtil.loadDocument((URL)Resources.getResource(CssEmmetOptions.class, (String)"emmet_default_options.xml"));
            Element prefixesElement = document.getRootElement().getChild("prefixes");
            if (prefixesElement != null) {
                for (Object entry : prefixesElement.getChildren("entry")) {
                    Element entryElement = (Element)entry;
                    String propertyName = entryElement.getAttributeValue("key");
                    Integer value = StringUtil.parseInt((String)entryElement.getAttributeValue("value"), (int)0);
                    result.put(propertyName, value);
                }
            }
        }
        catch (Exception e) {
            Logger.getInstance(CssEmmetOptions.class).warn((Throwable)e);
            return result;
        }
        return result;
    }

    public boolean isUnknownPropertiesExpansionEnabled() {
        return this.myUnknownPropertiesExpansionEnabled;
    }

    public void setUnknownPropertiesExpansionEnabled(boolean expandUnknownProperties) {
        this.myUnknownPropertiesExpansionEnabled = expandUnknownProperties;
    }
}

