/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.TooManySatisfiableConstructorsException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class CachingConstructorInjectionComponentAdapter
extends ConstructorInjectionComponentAdapter {
    private Object myInstance;

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses, ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (componentKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/util/pico/CachingConstructorInjectionComponentAdapter", "<init>"));
        }
        if (componentImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentImplementation", "com/intellij/util/pico/CachingConstructorInjectionComponentAdapter", "<init>"));
        }
        super(componentKey, componentImplementation, parameters, allowNonPublicClasses, monitor, lifecycleStrategy);
    }

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (componentKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/util/pico/CachingConstructorInjectionComponentAdapter", "<init>"));
        }
        if (componentImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentImplementation", "com/intellij/util/pico/CachingConstructorInjectionComponentAdapter", "<init>"));
        }
        super(componentKey, componentImplementation, parameters, allowNonPublicClasses);
    }

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters) {
        if (componentKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/util/pico/CachingConstructorInjectionComponentAdapter", "<init>"));
        }
        if (componentImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentImplementation", "com/intellij/util/pico/CachingConstructorInjectionComponentAdapter", "<init>"));
        }
        this(componentKey, componentImplementation, parameters, false);
    }

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (componentKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/util/pico/CachingConstructorInjectionComponentAdapter", "<init>"));
        }
        if (componentImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentImplementation", "com/intellij/util/pico/CachingConstructorInjectionComponentAdapter", "<init>"));
        }
        this(componentKey, componentImplementation, null);
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object instance = this.myInstance;
        if (instance == null) {
            this.myInstance = instance = super.getComponentInstance(container);
        }
        return instance;
    }

    protected Constructor getGreediestSatisfiableConstructor(PicoContainer container) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        HashSet<Constructor> conflicts = new HashSet<Constructor>();
        HashSet<List<Class>> unsatisfiableDependencyTypes = new HashSet<List<Class>>();
        List<Constructor> sortedMatchingConstructors = this.getSortedMatchingConstructors();
        Constructor greediestConstructor = null;
        int lastSatisfiableConstructorSize = -1;
        Class unsatisfiedDependencyType = null;
        for (Constructor constructor : sortedMatchingConstructors) {
            boolean failedDependency = false;
            Class[] parameterTypes = constructor.getParameterTypes();
            Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
            for (int j = 0; j < currentParameters.length; ++j) {
                if (currentParameters[j].isResolvable(container, (ComponentAdapter)this, parameterTypes[j])) continue;
                unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                unsatisfiedDependencyType = parameterTypes[j];
                failedDependency = true;
                break;
            }
            if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                if (conflicts.isEmpty()) {
                    return greediestConstructor;
                }
                conflicts.add(constructor);
                continue;
            }
            if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                conflicts.add(constructor);
                conflicts.add(greediestConstructor);
                continue;
            }
            if (failedDependency) continue;
            greediestConstructor = constructor;
            lastSatisfiableConstructorSize = parameterTypes.length;
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(this.getComponentImplementation(), conflicts);
        }
        if (greediestConstructor == null && !unsatisfiableDependencyTypes.isEmpty()) {
            throw new UnsatisfiableDependenciesException((ComponentAdapter)this, unsatisfiedDependencyType, unsatisfiableDependencyTypes, container);
        }
        if (greediestConstructor == null) {
            HashSet nonMatching = ContainerUtil.newHashSet((Object[])this.getConstructors());
            throw new PicoInitializationException("Either do the specified parameters not match any of the following constructors: " + ((Object)nonMatching).toString() + " or the constructors were not accessible for '" + this.getComponentImplementation() + "'");
        }
        return greediestConstructor;
    }

    private List<Constructor> getSortedMatchingConstructors() {
        ArrayList<Constructor> matchingConstructors = new ArrayList<Constructor>();
        for (Constructor constructor : this.getConstructors()) {
            if (this.parameters != null && constructor.getParameterTypes().length != this.parameters.length || !this.allowNonPublicClasses && (constructor.getModifiers() & 1) == 0) continue;
            matchingConstructors.add(constructor);
        }
        if (this.parameters == null) {
            Collections.sort(matchingConstructors, new Comparator<Constructor>(){

                @Override
                public int compare(Constructor arg0, Constructor arg1) {
                    return arg1.getParameterTypes().length - arg0.getParameterTypes().length;
                }
            });
        }
        return matchingConstructors;
    }

    private Constructor[] getConstructors() {
        return (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return CachingConstructorInjectionComponentAdapter.this.getComponentImplementation().getDeclaredConstructors();
            }
        });
    }
}

