/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.string;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.string.StringUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSJoinConcatenatedStringLiteralsIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        StringConcatPredicate stringConcatPredicate = new StringConcatPredicate();
        if (stringConcatPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/string/JSJoinConcatenatedStringLiteralsIntention", "getElementPredicate"));
        }
        return stringConcatPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/string/JSJoinConcatenatedStringLiteralsIntention", "processIntention"));
        }
        JSBinaryExpression expression = (JSBinaryExpression)element;
        JSExpression lhs = expression.getLOperand();
        JSExpression rhs = expression.getROperand();
        assert (lhs instanceof JSLiteralExpression && rhs instanceof JSLiteralExpression);
        JSLiteralExpression leftLiteral = (JSLiteralExpression)lhs;
        JSLiteralExpression rightLiteral = (JSLiteralExpression)rhs;
        String lhsText = lhs.getText();
        String rhsText = rhs.getText();
        if (StringUtil.isSingleQuoteStringLiteral((PsiElement)leftLiteral) && StringUtil.isDoubleQuoteStringLiteral((PsiElement)rightLiteral)) {
            rhsText = StringUtil.changeQuotes(rhsText);
        } else if (StringUtil.isDoubleQuoteStringLiteral((PsiElement)leftLiteral) && StringUtil.isSingleQuoteStringLiteral((PsiElement)rightLiteral)) {
            rhsText = StringUtil.changeQuotes(rhsText);
        }
        String newExpression = lhsText.substring(0, lhsText.length() - 1) + rhsText.substring(1);
        JSElementFactory.replaceExpression((JSExpression)expression, newExpression);
    }

    private static class StringConcatPredicate
    implements JSElementPredicate {
        private StringConcatPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/string/JSJoinConcatenatedStringLiteralsIntention$StringConcatPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression expression = (JSBinaryExpression)element;
            IElementType sign = expression.getOperationSign();
            if (sign == null || !sign.equals(JSTokenTypes.PLUS)) {
                return false;
            }
            JSExpression lhs = expression.getLOperand();
            JSExpression rhs = expression.getROperand();
            if (!StringConcatPredicate.isApplicableLiteral(lhs)) {
                return false;
            }
            return StringConcatPredicate.isApplicableLiteral(rhs);
        }

        private static boolean isApplicableLiteral(JSExpression lhs) {
            return lhs != null && lhs instanceof JSLiteralExpression && ((JSLiteralExpression)lhs).isQuotedLiteral();
        }
    }
}

