/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;

class ShiftUtils {
    private ShiftUtils() {
    }

    public static boolean isPowerOfTwo(JSExpression expression) {
        long intValue;
        if (!(expression instanceof JSLiteralExpression)) {
            return false;
        }
        String value = expression.getText();
        try {
            intValue = Integer.decode(value).longValue();
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (intValue <= 0L) {
            return false;
        }
        while ((intValue & 1L) == 0L) {
            intValue >>= 1;
        }
        return intValue == 1L;
    }

    public static int getLogBase2(JSExpression rhs) {
        long intValue;
        String value = rhs.getText();
        try {
            intValue = Integer.decode(value).longValue();
        }
        catch (NumberFormatException e) {
            assert (false);
            return 0;
        }
        int log = 0;
        while ((intValue & 1L) == 0L) {
            intValue >>= 1;
            ++log;
        }
        return log;
    }

    public static int getExpBase2(JSExpression rhs) {
        long intValue;
        String value = rhs.getText();
        try {
            intValue = Integer.decode(value).longValue();
        }
        catch (NumberFormatException e) {
            assert (false);
            return 0;
        }
        int exp = 1;
        int i = 0;
        while ((long)i < intValue) {
            exp <<= 1;
            ++i;
        }
        return exp;
    }

    public static boolean isIntLiteral(JSExpression expression) {
        if (!(expression instanceof JSLiteralExpression)) {
            return false;
        }
        if (!(expression instanceof JSLiteralExpression)) {
            return false;
        }
        String value = expression.getText();
        try {
            Integer.decode(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

