/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.conditional;

import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NotNull;

public class JSReplaceConditionalWithIfIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        ReplaceConditionalWithIfPredicate replaceConditionalWithIfPredicate = new ReplaceConditionalWithIfPredicate();
        if (replaceConditionalWithIfPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/conditional/JSReplaceConditionalWithIfIntention", "getElementPredicate"));
        }
        return replaceConditionalWithIfPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/conditional/JSReplaceConditionalWithIfIntention", "processIntention"));
        }
        assert (element instanceof JSConditionalExpression);
        ConditionalUtils.replaceConditionalWithIf((JSConditionalExpression)element);
    }

    private static class ReplaceConditionalWithIfPredicate
    implements JSElementPredicate {
        private ReplaceConditionalWithIfPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            JSConditionalExpression condExpr;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/conditional/JSReplaceConditionalWithIfIntention$ReplaceConditionalWithIfPredicate", "satisfiedBy"));
            }
            return element instanceof JSConditionalExpression && (condExpr = (JSConditionalExpression)element).getCondition() != null && condExpr.getThen() != null && condExpr.getElse() != null;
        }
    }
}

