/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.conditional;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSFlipIfIntention
extends JSIntention {
    @NonNls
    private static final String IF_PREFIX = "if (";
    @NonNls
    private static final String ELSE_KEYWORD = "else ";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        FlipIfPredicate flipIfPredicate = new FlipIfPredicate();
        if (flipIfPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/conditional/JSFlipIfIntention", "getElementPredicate"));
        }
        return flipIfPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/conditional/JSFlipIfIntention", "processIntention"));
        }
        JSIfStatement exp = (JSIfStatement)element;
        JSExpression condition = exp.getCondition();
        JSStatement thenBranch = exp.getThen();
        JSStatement elseBranch = exp.getElse();
        String negatedText = BoolUtils.getNegatedExpressionText(condition);
        boolean emptyThenBranch = thenBranch == null || thenBranch instanceof JSBlockStatement && ((JSBlockStatement)thenBranch).getStatements().length == 0;
        String thenText = emptyThenBranch ? "" : ELSE_KEYWORD + thenBranch.getText();
        boolean elseIsBlock = elseBranch instanceof JSBlockStatement;
        String elseText = elseBranch == null ? "{}" : (elseIsBlock ? "" : "{\n") + elseBranch.getText() + (elseIsBlock ? "" : "\n}");
        String newStatement = IF_PREFIX + negatedText + ')' + elseText + thenText;
        JSElementFactory.replaceStatement((JSStatement)exp, (String)newStatement);
    }

    private static class FlipIfPredicate
    implements JSElementPredicate {
        private FlipIfPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/conditional/JSFlipIfIntention$FlipIfPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSIfStatement) || ErrorUtil.containsError((PsiElement)element)) {
                return false;
            }
            JSIfStatement condition = (JSIfStatement)element;
            return condition.getCondition() != null;
        }
    }
}

