/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.psiutil.BinaryOperatorUtils;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSRemoveBooleanEqualityIntention
extends JSMutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        JSBinaryExpression binaryExpression = (JSBinaryExpression)element;
        return this.getText(BinaryOperatorUtils.getOperatorText(binaryExpression.getOperationSign()));
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        BooleanLiteralEqualityPredicate booleanLiteralEqualityPredicate = new BooleanLiteralEqualityPredicate();
        if (booleanLiteralEqualityPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/bool/JSRemoveBooleanEqualityIntention", "getElementPredicate"));
        }
        return booleanLiteralEqualityPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/bool/JSRemoveBooleanEqualityIntention", "processIntention"));
        }
        JSBinaryExpression exp = (JSBinaryExpression)element;
        boolean isEquals = exp.getOperationSign().equals(JSTokenTypes.EQEQ);
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        assert (lhs != null);
        assert (rhs != null);
        String lhsText = lhs.getText();
        String rhsText = rhs.getText();
        if ("true".equals(lhsText)) {
            if (isEquals) {
                JSElementFactory.replaceExpression((JSExpression)exp, rhsText);
            } else {
                JSElementFactory.replaceExpressionWithNegatedExpression(rhs, (JSExpression)exp);
            }
        } else if ("false".equals(lhsText)) {
            if (isEquals) {
                JSElementFactory.replaceExpressionWithNegatedExpression(rhs, (JSExpression)exp);
            } else {
                JSElementFactory.replaceExpression((JSExpression)exp, rhsText);
            }
        } else if ("true".equals(rhsText)) {
            if (isEquals) {
                JSElementFactory.replaceExpression((JSExpression)exp, lhsText);
            } else {
                JSElementFactory.replaceExpressionWithNegatedExpression(lhs, (JSExpression)exp);
            }
        } else if (isEquals) {
            JSElementFactory.replaceExpressionWithNegatedExpression(lhs, (JSExpression)exp);
        } else {
            JSElementFactory.replaceExpression((JSExpression)exp, lhsText);
        }
    }

    private static class BooleanLiteralEqualityPredicate
    implements JSElementPredicate {
        private BooleanLiteralEqualityPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/bool/JSRemoveBooleanEqualityIntention$BooleanLiteralEqualityPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSBinaryExpression)) {
                return false;
            }
            if (ErrorUtil.containsError((PsiElement)element)) {
                return false;
            }
            JSBinaryExpression expression = (JSBinaryExpression)element;
            IElementType sign = expression.getOperationSign();
            if (!JSTokenTypes.EQEQ.equals(sign) && !JSTokenTypes.NE.equals(sign)) {
                return false;
            }
            JSExpression lhs = expression.getLOperand();
            JSExpression rhs = expression.getROperand();
            return lhs != null && rhs != null && (BoolUtils.isBooleanLiteral(lhs) || BoolUtils.isBooleanLiteral(rhs));
        }
    }
}

