/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.Range;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.intellij.util.containers.ImmutableList;
import gnu.trove.TDoubleArrayList;
import gnu.trove.TLongHashSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LineChart
extends AnimatedComponent {
    private static final int ALPHA_MASK = -2013265920;
    private static final float DASH_LENGTH = 100.0f;
    private static final float X_TO_Y_RATIO = 0.01f;
    private static final int MARKER_RADIUS = 3;
    @NotNull
    private final Map<RangedContinuousSeries, LineConfig> mLinesConfig;
    @NotNull
    private final ArrayList<Path2D.Float> mPaths;
    @NotNull
    private final ArrayList<Point2D.Float> mMarkerPositions;
    private int mNextLineColorIndex;
    private String mName;
    @NotNull
    private final TLongHashSet mMarkedData;

    public LineChart() {
        this.mLinesConfig = new LinkedHashMap<RangedContinuousSeries, LineConfig>();
        this.mPaths = new ArrayList();
        this.mMarkerPositions = new ArrayList();
        this.mMarkedData = new TLongHashSet();
    }

    public LineChart(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/adtui/chart/linechart/LineChart", "<init>"));
        }
        this();
        this.mName = name;
    }

    public LineChart(@NotNull String name, @NotNull List<RangedContinuousSeries> data) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/adtui/chart/linechart/LineChart", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/adtui/chart/linechart/LineChart", "<init>"));
        }
        this(name);
        this.addLines(data);
    }

    public void addLine(@NotNull RangedContinuousSeries series, @NotNull LineConfig config) {
        if (series == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "series", "com/android/tools/adtui/chart/linechart/LineChart", "addLine"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/android/tools/adtui/chart/linechart/LineChart", "addLine"));
        }
        this.mLinesConfig.put(series, config);
    }

    public void addLine(@NotNull RangedContinuousSeries series) {
        if (series == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "series", "com/android/tools/adtui/chart/linechart/LineChart", "addLine"));
        }
        this.mLinesConfig.put(series, new LineConfig(LineConfig.COLORS[this.mNextLineColorIndex++]));
        this.mNextLineColorIndex %= LineConfig.COLORS.length;
    }

    public void addLines(@NotNull List<RangedContinuousSeries> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/adtui/chart/linechart/LineChart", "addLines"));
        }
        data.forEach(this::addLine);
    }

    @NotNull
    public LineConfig getLineConfig(RangedContinuousSeries rangedContinuousSeries) {
        LineConfig lineConfig = this.mLinesConfig.get(rangedContinuousSeries);
        if (lineConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/chart/linechart/LineChart", "getLineConfig"));
        }
        return lineConfig;
    }

    public void clearLineConfigs() {
        this.mLinesConfig.clear();
    }

    @NotNull
    public List<RangedContinuousSeries> getRangedContinuousSeries() {
        ArrayList<RangedContinuousSeries> arrayList = new ArrayList<RangedContinuousSeries>(this.mLinesConfig.keySet());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/chart/linechart/LineChart", "getRangedContinuousSeries"));
        }
        return arrayList;
    }

    @Override
    protected void updateData() {
        Range range;
        HashMap<Range, Double> max = new HashMap<Range, Double>();
        for (RangedContinuousSeries rangedContinuousSeries : this.mLinesConfig.keySet()) {
            range = rangedContinuousSeries.getYRange();
            double yMax = Double.MIN_VALUE;
            ImmutableList seriesList = rangedContinuousSeries.getSeries();
            for (int i = 0; i < seriesList.size(); ++i) {
                double value = ((Long)((SeriesData)seriesList.get((int)i)).value).longValue();
                if (!(yMax < value)) continue;
                yMax = value;
            }
            Double m = (Double)max.get(range);
            max.put(range, m == null ? yMax : Math.max(yMax, m));
        }
        for (Map.Entry entry : max.entrySet()) {
            range = (Range)entry.getKey();
            if (!(range.getInitialMax() < (Double)entry.getValue())) continue;
            range.setMaxTarget((Double)entry.getValue());
        }
    }

    @Override
    public void postAnimate() {
        long duration = System.nanoTime();
        int p = 0;
        TDoubleArrayList lastStackedSeriesY = null;
        ArrayList<Point2D.Float> lastStackedPath = null;
        this.mMarkerPositions.clear();
        for (RangedContinuousSeries ranged : this.mLinesConfig.keySet()) {
            Path2D.Float path;
            TDoubleArrayList currentSeriesY = new TDoubleArrayList();
            ArrayList<Point2D.Float> currentPath = new ArrayList<Point2D.Float>();
            LineConfig config = this.mLinesConfig.get(ranged);
            if (p == this.mPaths.size()) {
                path = new Path2D.Float();
                this.mPaths.add(path);
            } else {
                path = this.mPaths.get(p);
                path.reset();
            }
            double xMin = ranged.getXRange().getMin();
            double xMax = ranged.getXRange().getMax();
            double yMin = ranged.getYRange().getMin();
            double yMax = ranged.getYRange().getMax();
            long prevX = 0L;
            long prevY = 0L;
            float currentDashPercentage = 1.0f;
            double firstXd = 0.0;
            ImmutableList seriesList = ranged.getSeries();
            for (int i = 0; i < seriesList.size(); ++i) {
                SeriesData seriesData = (SeriesData)seriesList.get(i);
                long currX = seriesData.x;
                long currY = (Long)seriesData.value;
                double xd = ((double)currX - xMin) / (xMax - xMin);
                double yd = ((double)currY - yMin) / (yMax - yMin);
                if (config.isStacked() && lastStackedSeriesY != null && i < lastStackedSeriesY.size()) {
                    yd += lastStackedSeriesY.get(i);
                }
                currentSeriesY.add(yd);
                float adjustedYd = 1.0f - (float)yd;
                if (i == 0) {
                    path.moveTo(xd, (double)adjustedYd);
                    currentPath.add(new Point2D.Float((float)xd, adjustedYd));
                    firstXd = xd;
                } else if (config.isDashed() && !config.isFilled()) {
                    if (config.isStepped()) {
                        currentDashPercentage = LineChart.drawDash(path, currentDashPercentage, prevX, prevY, currX, prevY, xd, path.getCurrentPoint().getY());
                        prevX = currX;
                    }
                    currentDashPercentage = LineChart.drawDash(path, currentDashPercentage, prevX, prevY, currX, currY, xd, adjustedYd);
                } else {
                    if (config.isStepped()) {
                        float y = (float)path.getCurrentPoint().getY();
                        path.lineTo(xd, (double)y);
                        currentPath.add(new Point2D.Float((float)xd, y));
                    }
                    path.lineTo(xd, (double)adjustedYd);
                    currentPath.add(new Point2D.Float((float)xd, adjustedYd));
                }
                if (this.mMarkedData.contains(currX)) {
                    Point2D.Float point = new Point2D.Float((float)xd, adjustedYd);
                    this.mMarkerPositions.add(point);
                }
                prevX = currX;
                prevY = currY;
            }
            if (config.isFilled()) {
                if (config.isStacked() && lastStackedPath != null) {
                    int j = lastStackedPath.size();
                    while (j-- > 0) {
                        path.lineTo(((Point2D.Float)lastStackedPath.get(j)).getX(), ((Point2D.Float)lastStackedPath.get(j)).getY());
                    }
                } else if (path.getCurrentPoint() != null) {
                    path.lineTo(path.getCurrentPoint().getX(), 1.0);
                    path.lineTo(firstXd, 1.0);
                }
            }
            if (config.isStacked()) {
                lastStackedSeriesY = currentSeriesY;
                lastStackedPath = currentPath;
            }
            this.addDebugInfo("Range[%d] Max: %.2f", p, xMax);
            ++p;
        }
        this.mPaths.subList(p, this.mPaths.size()).clear();
        this.mMarkedData.clear();
        this.addDebugInfo("postAnimate time: %.2fms", Float.valueOf((float)(System.nanoTime() - duration) / 1000000.0f));
    }

    @Override
    protected void draw(Graphics2D g2d) {
        if (this.mPaths.size() != this.mLinesConfig.size()) {
            return;
        }
        Dimension dim = this.getSize();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform scale = AffineTransform.getScaleInstance(dim.getWidth(), dim.getHeight());
        int i = 0;
        for (RangedContinuousSeries ranged : this.mLinesConfig.keySet()) {
            LineConfig config = this.mLinesConfig.get(ranged);
            g2d.setColor(config.getColor());
            Shape shape = scale.createTransformedShape(this.mPaths.get(i));
            if (config.isFilled()) {
                int newColorRGBA = 0xFFFFFF & g2d.getColor().getRGB();
                g2d.setColor(new Color(newColorRGBA |= 0x88000000, true));
                g2d.fill(shape);
            } else {
                g2d.draw(shape);
            }
            ++i;
        }
        g2d.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
        for (Point2D.Float point : this.mMarkerPositions) {
            float x = point.x * (float)dim.width - 3.0f;
            float y = point.y * (float)dim.height - 3.0f;
            float diameter = 6.0f;
            Ellipse2D.Float ellipse = new Ellipse2D.Float(x, y, diameter, diameter);
            g2d.draw(ellipse);
        }
    }

    private static float computeDashLength(float dashLength, float xToYRatio, long prevX, long prevY, long currX, long currY, double prevXNorm, double prevYNorm, double currXNorm, double currYNorm) {
        float xDiff = currX - prevX;
        float yDiff = currY - prevY;
        float xDiffScaled = xDiff * xToYRatio;
        float angle = (float)Math.atan2(yDiff, xDiffScaled);
        float xRatio = (float)Math.cos(angle);
        float yRatio = (float)Math.sin(angle);
        float length = (float)Math.sqrt(Math.pow(dashLength * xRatio, 2.0) + Math.pow(dashLength * xToYRatio * yRatio, 2.0));
        float h = (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff);
        float numDashes = h / length;
        float xDiffNorm = (float)(currXNorm - prevXNorm);
        float yDiffNorm = (float)(currYNorm - prevYNorm);
        float hNorm = (float)Math.sqrt(xDiffNorm * xDiffNorm + yDiffNorm * yDiffNorm);
        return hNorm / numDashes;
    }

    private static float drawDash(Path2D.Float path, float dashPercentage, long prevX, long prevY, long nextX, long nextY, double currXNorm, double currYNorm) {
        if (prevX == nextX && prevY == nextY) {
            return dashPercentage;
        }
        double prevXNorm = path.getCurrentPoint().getX();
        double prevYNorm = path.getCurrentPoint().getY();
        float pathLength = (float)Point2D.distance(prevXNorm, prevYNorm, currXNorm, currYNorm);
        float dashLength = LineChart.computeDashLength(100.0f, 0.01f, prevX, prevY, nextX, nextY, prevXNorm, prevYNorm, currXNorm, currYNorm);
        float drawLength = dashLength / 2.0f;
        float currentDashPosition = dashPercentage * dashLength;
        while (pathLength > 0.0f) {
            double xd = currXNorm - prevXNorm;
            double yd = currYNorm - prevYNorm;
            if (currentDashPosition > drawLength) {
                float currentDrawLength = currentDashPosition - drawLength;
                float pathLengthToDraw = pathLength > currentDrawLength ? currentDrawLength : pathLength;
                path.lineTo(prevXNorm + xd * (double)pathLengthToDraw / (double)pathLength, prevYNorm + yd * (double)pathLengthToDraw / (double)pathLength);
                currentDashPosition -= pathLengthToDraw;
                pathLength -= pathLengthToDraw;
            } else {
                float pathLengthToDraw = pathLength > currentDashPosition ? currentDashPosition : pathLength;
                path.moveTo(prevXNorm + xd * (double)pathLengthToDraw / (double)pathLength, prevYNorm + yd * (double)pathLengthToDraw / (double)pathLength);
                currentDashPosition -= pathLengthToDraw;
                pathLength -= pathLengthToDraw;
            }
            prevXNorm = path.getCurrentPoint().getX();
            prevYNorm = path.getCurrentPoint().getY();
            if (currentDashPosition != 0.0f) continue;
            currentDashPosition = dashLength;
        }
        return currentDashPosition / dashLength;
    }
}

