/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.ValuedTreeNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public final class SunburstChart
extends AnimatedComponent {
    private static final Color[] COLORS = new Color[]{new Color(7057110), new Color(13032431), new Color(16616764), new Color(16634018), new Color(7652470), new Color(13101504), new Color(10394312), new Color(14342891), new Color(0x969696), new Color(0xD9D9D9)};
    private static final Color[] HIGHLIGHTS = new Color[]{new Color(3244733), new Color(10406625), new Color(15095053), new Color(16625259), new Color(3253076), new Color(10607003), new Color(7695281), new Color(0xBCBDDC), new Color(0x636363), new Color(0xBDBDBD)};
    private ValuedTreeNode mData;
    private Slice mSlice;
    private float mGap;
    private float mStart;
    private float mFixed;
    private float mAngle;
    private float mCurrentAngle;
    private float mSeparator;
    private boolean mAutoSize;
    private float mSliceWidth;
    private boolean myUseCount;
    private int mySelectionLevel;
    private int myZoomLevel;
    private Slice mySelection;
    private Slice myZoom;
    private boolean myLockSelection;
    private final List<SliceSelectionListener> mListeners;
    private float mX;
    private float mY;
    private float mMaxDepth;
    private float mMaxSide;
    private float mCenterX;
    private float mCenterY;
    private float mDelta;
    private Point2D.Float mDirection;
    private Map<Color, Path2D.Float> mPaths;

    public SunburstChart(@NotNull ValuedTreeNode data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/adtui/chart/SunburstChart", "<init>"));
        }
        this.mData = data;
        this.mSlice = new Slice(0.0f);
        this.mSliceWidth = 50.0f;
        this.mGap = 50.0f;
        this.mX = -1.0f;
        this.mY = -1.0f;
        this.mAngle = 360.0f;
        this.mCurrentAngle = 360.0f;
        this.mDelta = 0.0f;
        this.mFixed = 60.0f;
        this.mStart = 180.0f;
        this.mSeparator = 1.0f;
        this.mySelectionLevel = -1;
        this.myLockSelection = false;
        this.mPaths = new HashMap<Color, Path2D.Float>();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SunburstChart.this.myZoom = SunburstChart.this.mySelection;
                    SunburstChart.this.myZoomLevel = SunburstChart.this.mySelectionLevel;
                    SunburstChart.this.myLockSelection = false;
                } else {
                    SunburstChart.this.myLockSelection = !SunburstChart.this.myLockSelection && SunburstChart.this.mySelection != null;
                }
            }
        });
        this.mListeners = new LinkedList<SliceSelectionListener>();
    }

    @Override
    protected void draw(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dim = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, dim.width, dim.height);
        this.mPaths.clear();
        this.drawSlice(this.mSlice, 0.0f, 0.0f, 1.0f);
        for (Map.Entry<Color, Path2D.Float> entry : this.mPaths.entrySet()) {
            g.setColor(entry.getKey());
            g.fill(entry.getValue());
        }
    }

    @Override
    protected void updateData() {
        Dimension dim = this.getSize();
        this.mX = (float)dim.width * 0.5f;
        this.mY = (float)dim.height * 0.5f;
        this.updateArea();
        this.updateStructure(this.mSlice, this.mData, false);
        this.mCurrentAngle = Choreographer.lerp(this.mCurrentAngle, this.mAngle, 0.999f, this.mFrameLength, 0.1f);
        if (this.mAutoSize) {
            float full = Math.min(this.mMaxDepth, this.mMaxSide) - this.mGap - 20.0f;
            float none = this.mMaxDepth * 2.0f - this.mGap - 20.0f;
            float factor = this.mCurrentAngle / 360.0f;
            float depth = full * factor + none * (1.0f - factor);
            this.mFixed = Choreographer.lerp(this.mFixed, (float)((double)(this.mMaxSide - 20.0f) / Math.PI), 0.999f, this.mFrameLength);
            float width = depth / SunburstChart.getMaxDepth(this.mSlice);
            this.mSliceWidth = Choreographer.lerp(this.mSliceWidth, width, 0.999f, this.mFrameLength);
        }
        this.mDelta = 360.0f * this.mFixed / this.mCurrentAngle - this.mFixed;
        this.mDirection = new Point2D.Float((float)Math.cos((double)this.mStart * Math.PI / 180.0), -((float)Math.sin((double)this.mStart * Math.PI / 180.0)));
        this.mCenterX = this.mX + (this.mDelta + this.mMaxDepth * (360.0f - this.mCurrentAngle) / 360.0f) * this.mDirection.x;
        this.mCenterY = this.mY + (this.mDelta + this.mMaxDepth * (360.0f - this.mCurrentAngle) / 360.0f) * this.mDirection.y;
        this.updateSelection();
        this.updateSlice(this.mSlice, 0, this.myZoom == null);
    }

    private void updateSelection() {
        Point mouse = this.getMousePosition();
        if (!this.myLockSelection) {
            boolean selection = false;
            if (mouse != null) {
                float value;
                float depth;
                if (this.mCurrentAngle > 0.0f) {
                    float distance = (float)mouse.distance(this.mCenterX, this.mCenterY);
                    depth = (distance - this.mGap - this.mDelta) / this.mSliceWidth;
                    float angle = -((float)Math.toDegrees(Math.atan2((float)mouse.y - this.mCenterY, (float)mouse.x - this.mCenterX)));
                    angle = (angle = (angle - this.mStart - 180.0f + this.mCurrentAngle * 0.5f) % 360.0f) < 0.0f ? angle + 360.0f : angle;
                    value = angle / this.mCurrentAngle;
                } else {
                    float length = (float)(Math.PI * 2 * (double)this.mFixed);
                    depth = ((float)mouse.x - this.mX) * this.mDirection.x + ((float)mouse.y - this.mY) * this.mDirection.y - (this.mMaxDepth - this.mGap);
                    value = ((float)mouse.x - this.mX) * this.mDirection.y + ((float)mouse.y - this.mY) * -this.mDirection.x;
                    depth = -depth / this.mSliceWidth;
                    value = -value / length + 0.5f;
                }
                selection = this.updateSelectedSlice(this.mSlice, depth, value, 0);
            }
            if (!selection) {
                this.mySelectionLevel = -1;
                if (this.mySelection != null) {
                    this.mySelection = null;
                    this.fireSliceSelected(new SliceSelectionEvent(null));
                }
            }
        } else if (this.mySelection != null && this.mySelection.node == null) {
            this.myLockSelection = false;
            this.mySelectionLevel = -1;
            this.mySelection = null;
            this.fireSliceSelected(new SliceSelectionEvent(null));
        }
        if (this.myZoom != null && this.myZoom.node == null) {
            this.resetZoom();
        }
    }

    public void resetZoom() {
        this.myZoom = null;
        this.myZoomLevel = -1;
    }

    private boolean updateSlice(Slice slice, int level, boolean zoom) {
        zoom = zoom || slice == this.myZoom;
        boolean children = false;
        for (int i = 0; i < slice.getChildrenCount(); ++i) {
            Slice child = slice.getChild(i);
            children = this.updateSlice(child, level + 1, zoom) || children;
        }
        zoom = zoom || children;
        slice.selected = Choreographer.lerp(slice.selected, slice == this.mySelection ? 1.0f : 0.0f, 0.99f, this.mFrameLength);
        slice.visible = Choreographer.lerp(slice.visible, zoom ? 1.0f : 0.0f, 0.99f, this.mFrameLength);
        slice.zoom = Choreographer.lerp(slice.zoom, level < this.myZoomLevel ? (level == this.myZoomLevel - 1 ? 0.5f : 0.0f) : 1.0f, 0.99f, this.mFrameLength);
        return zoom;
    }

    private boolean updateSelectedSlice(Slice slice, float depth, float value, int level) {
        if (depth < 0.0f || value < 0.0f || value > 1.0f) {
            return false;
        }
        if (depth < slice.getDepth()) {
            this.mySelectionLevel = level;
            if (this.mySelection != slice) {
                this.mySelection = slice;
                this.fireSliceSelected(new SliceSelectionEvent(slice.node));
            }
            return true;
        }
        depth -= slice.getDepth();
        float total = 0.0f;
        for (Slice child : slice.getChildren()) {
            total += child.getValue();
        }
        float current = 0.0f;
        for (int i = 0; i < slice.getChildrenCount(); ++i) {
            Slice child = slice.getChild(i);
            float val = child.getValue() / total;
            if (value < current + val || i == slice.getChildrenCount() - 1) {
                value = (value - current) / val;
                return this.updateSelectedSlice(child, depth, value, level + 1);
            }
            current += val;
        }
        return false;
    }

    private void fireSliceSelected(SliceSelectionEvent event) {
        for (SliceSelectionListener listener : this.mListeners) {
            listener.valueChanged(event);
        }
    }

    @Override
    protected void debugDraw(Graphics2D g2d) {
        this.addDebugInfo("Total slices: %d", this.mData.getCount());
        this.addDebugInfo("Paths %d", this.mPaths.size());
        g2d.setColor(Color.GREEN);
        SunburstChart.drawArrow(g2d, this.mX, this.mY, this.mDirection.x, this.mDirection.y, this.mMaxDepth, Color.MAGENTA);
        SunburstChart.drawArrow(g2d, this.mX, this.mY, this.mDirection.y, -this.mDirection.x, this.mMaxSide, Color.MAGENTA);
        if (this.mCurrentAngle == 0.0f) {
            Path2D.Float fixed = new Path2D.Float();
            float length = (float)(Math.PI * 2 * (double)this.mFixed) * 0.5f;
            fixed.moveTo(this.mX + (this.mMaxDepth * (360.0f - this.mCurrentAngle) / 360.0f - this.mFixed) * this.mDirection.x - this.mDirection.y * length, this.mY + (this.mMaxDepth * (360.0f - this.mCurrentAngle) / 360.0f - this.mFixed) * this.mDirection.y + this.mDirection.x * length);
            fixed.lineTo(this.mX + (this.mMaxDepth * (360.0f - this.mCurrentAngle) / 360.0f - this.mFixed) * this.mDirection.x + this.mDirection.y * length, this.mY + (this.mMaxDepth * (360.0f - this.mCurrentAngle) / 360.0f - this.mFixed) * this.mDirection.y - this.mDirection.x * length);
            g2d.draw(fixed);
        } else {
            SunburstChart.drawMarker(g2d, this.mCenterX, this.mCenterY, Color.BLUE);
            Arc2D.Float fixed = new Arc2D.Float();
            fixed.setArcByCenter(this.mCenterX, this.mCenterY, this.mDelta + this.mFixed, this.mStart + (360.0f - this.mCurrentAngle) * 0.5f, this.mCurrentAngle, 0);
            g2d.draw(fixed);
        }
    }

    private void updateArea() {
        float angle = (float)Math.toRadians(this.mStart);
        float a = (float)Math.cos(angle) * this.mY;
        float b = (float)Math.sin(angle) * this.mX;
        this.mMaxDepth = this.mX * this.mY / (float)Math.sqrt(a * a + b * b);
        a = (float)Math.cos((double)angle + 1.5707963267948966) * this.mY;
        b = (float)Math.sin((double)angle + 1.5707963267948966) * this.mX;
        this.mMaxSide = this.mX * this.mY / (float)Math.sqrt(a * a + b * b);
    }

    private float getFraction(ValuedTreeNode node) {
        TreeNode parent = node.getParent();
        assert (parent == null || parent instanceof ValuedTreeNode);
        if (this.myUseCount) {
            return parent == null ? 1.0f : (float)node.getCount() / (float)((ValuedTreeNode)parent).getCount();
        }
        return parent == null ? 1.0f : (float)node.getValue() / (float)((ValuedTreeNode)parent).getValue();
    }

    private static ValuedTreeNode getChildAt(ValuedTreeNode node, int i) {
        TreeNode child = node.getChildAt(i);
        assert (child instanceof ValuedTreeNode);
        return (ValuedTreeNode)child;
    }

    private static float getMaxDepth(Slice slice) {
        float depth = 0.0f;
        for (Slice child : slice.getChildren()) {
            depth = Math.max(depth, SunburstChart.getMaxDepth(child));
        }
        return depth + slice.depth;
    }

    private boolean updateStructure(Slice slice, ValuedTreeNode node, boolean hasSiblings) {
        ValuedTreeNode childNode;
        if (node == null) {
            slice.depth = Choreographer.lerp(slice.depth, hasSiblings ? slice.depth : 0.0f, 0.99f, this.mFrameLength);
            slice.value = Choreographer.lerp(slice.value, hasSiblings ? 0.0f : slice.value, 0.99f, this.mFrameLength);
        } else {
            slice.depth = Choreographer.lerp(slice.depth, node.getParent() == null ? 0.0f : 1.0f, 0.99f, this.mFrameLength);
            slice.value = Choreographer.lerp(slice.value, this.getFraction(node), 0.99f, this.mFrameLength);
        }
        slice.node = node;
        int last = -1;
        int slices = slice.getChildrenCount();
        int nodes = node == null ? 0 : node.getChildCount();
        for (int i = 0; i < slices; ++i) {
            Slice childSlice = slice.getChild(i);
            if (!this.updateStructure(childSlice, childNode = i < nodes ? SunburstChart.getChildAt(node, i) : null, nodes > 0)) continue;
            last = i;
        }
        int c = slices > 0 ? slice.getChild((int)0).color : (slice.color + (int)(Math.random() * (double)COLORS.length - 1.0) + 1) % COLORS.length;
        for (int i = slices; i < nodes; ++i) {
            childNode = SunburstChart.getChildAt(node, i);
            Slice childSlice = new Slice(slices > 0 ? 0.0f : this.getFraction(childNode));
            childSlice.color = c;
            childSlice.depth = slices > 0 ? 1.0f : 0.0f;
            slice.addChild(childSlice);
            if (!this.updateStructure(childSlice, childNode, nodes > 0)) continue;
            last = i;
        }
        if (last + 1 < slice.getChildrenCount()) {
            slice.clearSublist(last + 1, slice.getChildrenCount());
        }
        return node != null || slice.depth > 1.0E-5f && slice.value > 1.0E-5f || last >= 0;
    }

    private Path2D.Float getPath(Color color) {
        Path2D.Float path = this.mPaths.get(color);
        if (path == null) {
            path = new Path2D.Float();
            this.mPaths.put(color, path);
        }
        return path;
    }

    private void drawSlice(Slice slice, float depth, float from, float to) {
        if (slice.getDepth() > 0.0f) {
            Color c = COLORS[slice.color];
            float s = slice.selected;
            Color b = HIGHLIGHTS[slice.color];
            c = new Color((int)((float)b.getRed() * s + (float)c.getRed() * (1.0f - s)), (int)((float)b.getGreen() * s + (float)c.getGreen() * (1.0f - s)), (int)((float)b.getBlue() * s + (float)c.getBlue() * (1.0f - s)));
            Path2D.Float path = this.getPath(c);
            if (this.mCurrentAngle == 0.0f) {
                float length = (float)(Math.PI * 2 * (double)this.mFixed);
                float delta = this.mGap + depth * this.mSliceWidth - this.mMaxDepth + this.mSeparator * 0.5f + slice.getBorder() * this.mSliceWidth;
                float up = length * (0.5f - from) - this.mSeparator * 0.5f;
                float down = length * (0.5f - to) + this.mSeparator * 0.5f;
                float size = this.mSliceWidth * slice.getDepth() - this.mSeparator - slice.getBorder() * this.mSliceWidth * 2.0f;
                float deltaX = this.mDirection.x * delta;
                float deltaY = this.mDirection.y * delta;
                float upX = this.mDirection.y * up;
                float upY = -this.mDirection.x * up;
                float downX = this.mDirection.y * down;
                float downY = -this.mDirection.x * down;
                float sizeX = this.mDirection.x * size;
                float sizeY = this.mDirection.y * size;
                if (up > down) {
                    path.moveTo(this.mX - deltaX + upX, this.mY - deltaY + upY);
                    path.lineTo(this.mX - deltaX + upX - sizeX, this.mY - deltaY + upY - sizeY);
                    path.lineTo(this.mX - deltaX + downX - sizeX, this.mY - deltaY + downY - sizeY);
                    path.lineTo(this.mX - deltaX + downX, this.mY - deltaY + downY);
                    path.closePath();
                }
            } else {
                float angle = (360.0f - this.mCurrentAngle) * 0.5f + this.mCurrentAngle * from + this.mStart;
                float arc = this.mCurrentAngle * (to - from);
                float radius = this.mSliceWidth * depth + this.mGap + this.mDelta;
                float outerLen = (radius + this.mSliceWidth * slice.getDepth()) * (float)Math.toRadians(arc);
                if (outerLen < 1.0f) {
                    path = this.getPath(Color.RED);
                }
                float outerRadius = radius + this.mSliceWidth * slice.getDepth() - this.mSeparator * 0.5f - slice.getBorder() * this.mSliceWidth;
                float innerRadius = radius + this.mSeparator * 0.5f + slice.getBorder() * this.mSliceWidth;
                float outerAngle = (float)Math.toDegrees(Math.asin(this.mSeparator / outerRadius));
                if (outerAngle < arc && outerRadius > innerRadius) {
                    Arc2D.Float outer = new Arc2D.Float();
                    outer.setArcByCenter(this.mCenterX, this.mCenterY, outerRadius, angle + outerAngle * 0.5f, arc - outerAngle, 0);
                    path.append(outer, false);
                    float innerAngle = (float)Math.toDegrees(Math.asin(this.mSeparator / innerRadius));
                    if (innerAngle < arc) {
                        Arc2D.Float inner = new Arc2D.Float();
                        inner.setArcByCenter(this.mCenterX, this.mCenterY, innerRadius, angle + innerAngle * 0.5f + arc - innerAngle, -(arc - innerAngle), 0);
                        path.append(inner, true);
                    } else {
                        float r = (float)((double)(this.mSeparator * 0.5f) / Math.sin(Math.toRadians(arc * 0.5f)));
                        float dx = (float)(Math.cos(Math.toRadians(angle + arc * 0.5f)) * (double)r);
                        float dy = (float)(Math.sin(Math.toRadians(angle + arc * 0.5f)) * (double)r);
                        path.lineTo(this.mCenterX + dx, this.mCenterY - dy);
                    }
                    path.lineTo(outer.getStartPoint().getX(), outer.getStartPoint().getY());
                }
            }
        }
        float total = 0.0f;
        for (Slice child : slice.getChildren()) {
            total += child.getValue();
        }
        float value = 0.0f;
        for (Slice child : slice.getChildren()) {
            float childFrom = from + value / total * (to - from);
            float childTo = from + (value + child.getValue()) / total * (to - from);
            this.drawSlice(child, depth + slice.getDepth(), childFrom, childTo);
            value += child.getValue();
        }
    }

    public void setGap(float gap) {
        this.mGap = gap;
    }

    public void setSliceWidth(float sliceWidth) {
        this.mSliceWidth = sliceWidth;
    }

    public void setAngle(float angle) {
        this.mAngle = angle;
    }

    public void setStart(float start) {
        this.mStart = start;
        this.updateArea();
    }

    public void setFixed(int fixed) {
        this.mFixed = fixed;
    }

    public float getGap() {
        return this.mGap;
    }

    public float getSliceWidth() {
        return this.mSliceWidth;
    }

    public float getStart() {
        return this.mStart;
    }

    public float getFixed() {
        return this.mFixed;
    }

    public float getAngle() {
        return this.mAngle;
    }

    public float getSeparator() {
        return this.mSeparator;
    }

    public void setSeparator(float separator) {
        this.mSeparator = separator;
    }

    public void setData(ValuedTreeNode data) {
        this.mData = data;
    }

    public ValuedTreeNode getData() {
        return this.mData;
    }

    public void setAutoSize(boolean autoSize) {
        this.mAutoSize = autoSize;
    }

    public void setUseCount(boolean useCount) {
        this.myUseCount = useCount;
    }

    public void addSelectionListener(SliceSelectionListener listener) {
        this.mListeners.add(listener);
    }

    public void removeSelectionListener(SliceSelectionListener listener) {
        this.mListeners.remove(listener);
    }

    public static interface SliceSelectionListener {
        public void valueChanged(SliceSelectionEvent var1);
    }

    public static class SliceSelectionEvent {
        private final ValuedTreeNode mNode;

        public SliceSelectionEvent(ValuedTreeNode node) {
            this.mNode = node;
        }

        public ValuedTreeNode getNode() {
            return this.mNode;
        }
    }

    static class Slice {
        private ArrayList<Slice> children = new ArrayList();
        Slice parent;
        float value;
        float depth;
        int color;
        float hover;
        float zoom;
        float selected;
        float visible;
        ValuedTreeNode node;

        public float getValue() {
            return this.value * this.visible;
        }

        public float getBorder() {
            return this.selected * this.depth * 0.05f;
        }

        public float getDepth() {
            return this.zoom * this.depth + this.getBorder() * 2.0f;
        }

        public Slice(float value) {
            this.value = value;
            this.depth = 1.0f;
            this.hover = 0.0f;
            this.selected = 0.0f;
            this.zoom = 1.0f;
            this.visible = 1.0f;
        }

        public int getChildrenCount() {
            return this.children.size();
        }

        public void addChild(Slice child) {
            this.children.add(child);
            child.parent = this;
        }

        public Slice getChild(int i) {
            return this.children.get(i);
        }

        public void clearSublist(int from, int to) {
            for (int i = from; i < to; ++i) {
                this.children.get((int)i).parent = null;
            }
            this.children.subList(from, to).clear();
        }

        public ArrayList<Slice> getChildren() {
            return this.children;
        }
    }
}

