/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.bnd.build.model.EE;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.version.VersionRange;
import biz.aQute.resolve.AbstractResolveContext;
import org.osgi.resource.Resource;
import org.osgi.service.log.LogService;

public class GenericResolveContext
extends AbstractResolveContext {
    protected static final String CONTRACT_OSGI_FRAMEWORK = "OSGiFramework";
    protected static final String IDENTITY_INITIAL_RESOURCE = "<<INITIAL>>";
    protected static final String IDENTITY_SYSTEM_RESOURCE = "<<SYSTEM>>";
    private boolean initialised = false;
    private ResourceBuilder system = new ResourceBuilder();
    private ResourceBuilder input = new ResourceBuilder();

    public GenericResolveContext(LogService log) {
        super(log);
    }

    @Override
    public synchronized void init() {
        if (this.initialised) {
            return;
        }
        try {
            this.initialised = true;
            this.setInputResource(this.input.build());
            this.setSystemResource(this.system.build());
            super.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ResourceBuilder getInput() {
        return this.input;
    }

    public ResourceBuilder getSystem() {
        return this.system;
    }

    public void addFramework(String framework, String version) throws Exception {
        Resource r = this.getHighestResource(framework, version);
        this.setFramework(this.system, r);
    }

    public void addEE(EE ee) throws Exception {
        this.system.addAllExecutionEnvironments(ee);
    }

    public void addRequireBundle(String bsn, VersionRange versionRange) throws Exception {
        this.input.addRequireBundle(bsn, versionRange);
    }

    public void done() {
        this.init();
    }
}

