/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.bnd.deployer.repository.CapabilityIndex;
import aQute.bnd.deployer.repository.MapToDictionaryAdapter;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.Filters;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.service.resolve.hook.ResolverHook;
import aQute.bnd.version.VersionRange;
import aQute.lib.io.IO;
import aQute.libg.filters.AndFilter;
import aQute.libg.filters.LiteralFilter;
import aQute.libg.filters.SimpleFilter;
import biz.aQute.resolve.DebugReporter;
import biz.aQute.resolve.ResolutionCallback;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wiring;
import org.osgi.service.log.LogService;
import org.osgi.service.repository.Repository;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolveContext;

public abstract class AbstractResolveContext
extends ResolveContext {
    static Set<String> IGNORED_NAMESPACES_FOR_SYSTEM_RESOURCES = new HashSet<String>();
    protected static final String CONTRACT_OSGI_FRAMEWORK = "OSGiFramework";
    protected static final String IDENTITY_INITIAL_RESOURCE = "<<INITIAL>>";
    protected static final String IDENTITY_SYSTEM_RESOURCE = "<<SYSTEM>>";
    protected final LogService log;
    private CapabilityIndex systemCapabilityIndex = new CapabilityIndex();
    private final List<Repository> repositories = new ArrayList<Repository>();
    private final List<Requirement> failed = new ArrayList<Requirement>();
    private final Map<CacheKey, List<Capability>> providerCache = new HashMap<CacheKey, List<Capability>>();
    private final Set<Resource> optionalRoots = new HashSet<Resource>();
    private final ConcurrentMap<Resource, Integer> resourcePriorities = new ConcurrentHashMap<Resource, Integer>();
    private final Comparator<Capability> capabilityComparator;
    private Map<String, Set<String>> effectiveSet = new HashMap<String, Set<String>>();
    private final List<ResolverHook> resolverHooks = new ArrayList<ResolverHook>();
    private final List<ResolutionCallback> callbacks = new LinkedList<ResolutionCallback>();
    private boolean initialised = false;
    private Resource systemResource;
    private Resource inputResource;
    private Set<Resource> blacklistedResources = new HashSet<Resource>();
    private int level = 0;
    private Resource framework;

    public AbstractResolveContext(LogService log) {
        this.log = log;
        this.capabilityComparator = new CapabilityComparator(log);
    }

    protected synchronized void init() {
        if (this.initialised) {
            return;
        }
        try {
            this.failed.clear();
            this.systemCapabilityIndex.addResource(this.systemResource);
            if (this.level > 0) {
                DebugReporter dr = new DebugReporter(System.out, this, this.level);
                dr.report();
            }
            this.initialised = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Capability> findProviders(Requirement requirement) {
        this.init();
        List<Capability> result = this.findProviders0(requirement);
        if (result == null || result.isEmpty()) {
            this.failed.add(requirement);
        }
        return result;
    }

    @Override
    public Collection<Resource> getMandatoryResources() {
        this.init();
        return Collections.singleton(this.getInputResource());
    }

    @Override
    public int insertHostedCapability(List<Capability> caps, HostedCapability hc) {
        this.init();
        Integer prioObj = (Integer)this.resourcePriorities.get(hc.getResource());
        int priority = prioObj != null ? prioObj : Integer.MAX_VALUE;
        for (int i = 0; i < caps.size(); ++i) {
            int otherPriority;
            Capability c = caps.get(i);
            Integer otherPrioObj = (Integer)this.resourcePriorities.get(c.getResource());
            int n = otherPriority = otherPrioObj != null ? otherPrioObj : 0;
            if (otherPriority <= priority) continue;
            caps.add(i, hc);
            return i;
        }
        int newIndex = caps.size();
        caps.add(newIndex, hc);
        return newIndex;
    }

    @Override
    public boolean isEffective(Requirement requirement) {
        this.init();
        String effective = (String)requirement.getDirectives().get("effective");
        if (effective == null || "resolve".equals(effective)) {
            return true;
        }
        return this.effectiveSet != null && this.effectiveSet.containsKey(effective) && !this.effectiveSet.get(effective).contains(requirement.getNamespace());
    }

    @Override
    public Map<Resource, Wiring> getWirings() {
        this.init();
        return Collections.emptyMap();
    }

    private List<Capability> findProviders0(Requirement requirement) {
        ArrayList<Capability> result;
        this.init();
        CacheKey cacheKey = AbstractResolveContext.getCacheKey(requirement);
        List<Capability> cached = this.providerCache.get(cacheKey);
        if (cached != null) {
            result = new ArrayList<Capability>(cached);
        } else {
            LinkedHashSet<Capability> firstStageResult = new LinkedHashSet<Capability>();
            this.systemCapabilityIndex.appendMatchingCapabilities(requirement, firstStageResult);
            this.processMandatoryResource(requirement, firstStageResult, requirement.getResource());
            for (Resource res : this.getMandatoryResources()) {
                this.processMandatoryResource(requirement, firstStageResult, res);
            }
            boolean optional = "optional".equals(requirement.getDirectives().get("resolution"));
            if (optional && !this.optionalRoots.contains(requirement.getResource())) {
                result = new ArrayList<Capability>(firstStageResult);
                Collections.sort(result, this.capabilityComparator);
            } else {
                ArrayList<Capability> secondStageList = this.findProvidersFromRepositories(requirement, firstStageResult);
                firstStageResult.addAll(secondStageList);
                result = new ArrayList<Capability>(firstStageResult);
            }
            this.providerCache.put(cacheKey, result);
        }
        this.log.log(4, "for " + requirement + " found " + result);
        return result;
    }

    protected void processMandatoryResource(Requirement requirement, LinkedHashSet<Capability> firstStageResult, Resource resource) {
        List selfCaps;
        if (resource != null && (selfCaps = resource.getCapabilities(requirement.getNamespace())) != null) {
            for (Capability selfCap : selfCaps) {
                if (!this.matches(requirement, selfCap)) continue;
                firstStageResult.add(selfCap);
            }
        }
    }

    protected ArrayList<Capability> findProvidersFromRepositories(Requirement requirement, LinkedHashSet<Capability> existingWiredCapabilities) {
        ArrayList secondStageResult = new ArrayList();
        int order = 0;
        ArrayList<Capability> repoCapabilities = new ArrayList<Capability>();
        for (Repository repo : this.repositories) {
            repoCapabilities.clear();
            Collection<Capability> capabilities = this.findProviders(repo, requirement);
            if (capabilities != null && !capabilities.isEmpty()) {
                repoCapabilities.ensureCapacity(capabilities.size());
                for (Capability capability : capabilities) {
                    if (!this.isPermitted(capability.getResource()) || !this.isCorrectEffectiveness(requirement, capability)) continue;
                    repoCapabilities.add(capability);
                    this.setResourcePriority(order, capability.getResource());
                }
                secondStageResult.addAll(repoCapabilities);
            }
            ++order;
        }
        Collections.sort(secondStageResult, this.capabilityComparator);
        ArrayList<Capability> secondStageList = new ArrayList<Capability>(secondStageResult);
        this.postProcessProviders(requirement, existingWiredCapabilities, secondStageList);
        return secondStageList;
    }

    protected Collection<Capability> findProviders(Repository repo, Requirement requirement) {
        Map map = repo.findProviders(Collections.singleton(requirement));
        if (map.isEmpty()) {
            return Collections.emptySet();
        }
        Collection caps = (Collection)map.get(requirement);
        Iterator c = caps.iterator();
        while (c.hasNext()) {
            Capability capability = (Capability)c.next();
            if (!this.blacklistedResources.contains(capability.getResource())) continue;
            c.remove();
        }
        return caps;
    }

    private void setResourcePriority(int priority, Resource resource) {
        this.resourcePriorities.putIfAbsent(resource, priority);
    }

    public static Requirement createBundleRequirement(String bsn, String versionStr) {
        return CapReqBuilder.createBundleRequirement((String)bsn, (String)versionStr).buildSyntheticRequirement();
    }

    private boolean matches(Requirement requirement, Capability selfCap) {
        boolean match = false;
        if (this.isCorrectEffectiveness(requirement, selfCap)) {
            try {
                Filter filter;
                String filterStr = (String)requirement.getDirectives().get("filter");
                Filter filter2 = filter = filterStr != null ? FrameworkUtil.createFilter((String)filterStr) : null;
                match = filter == null ? true : filter.match((Dictionary)new MapToDictionaryAdapter(selfCap.getAttributes()));
            }
            catch (InvalidSyntaxException e) {
                this.log.log(1, "Invalid filter directive on requirement: " + requirement, e);
            }
        }
        return match;
    }

    private boolean isCorrectEffectiveness(Requirement requirement, Capability cap) {
        String capEffective;
        boolean result = false;
        String reqEffective = (String)requirement.getDirectives().get("effective");
        result = reqEffective == null || "resolve".equals(reqEffective) ? (capEffective = (String)cap.getDirectives().get("effective")) == null || "resolve".equals(capEffective) : true;
        return result;
    }

    public void setOptionalRoots(Collection<Resource> roots) {
        this.optionalRoots.clear();
        this.optionalRoots.addAll(roots);
    }

    public void addRepository(Repository repo) {
        this.repositories.add(repo);
    }

    public List<Repository> getRepositories() {
        return this.repositories;
    }

    public List<Requirement> getFailed() {
        return this.failed;
    }

    private boolean isPermitted(Resource resource) {
        Capability fwkCap = AbstractResolveContext.findFrameworkContractCapability(resource);
        if (fwkCap != null) {
            return false;
        }
        List idCaps = resource.getCapabilities("osgi.identity");
        if (idCaps == null || idCaps.isEmpty()) {
            this.log.log(1, "Resource is missing an identity capability (osgi.identity).");
            return false;
        }
        if (idCaps.size() > 1) {
            this.log.log(1, "Resource has more than one identity capability (osgi.identity).");
            return false;
        }
        String identity = (String)((Capability)idCaps.get(0)).getAttributes().get("osgi.identity");
        if (identity == null) {
            this.log.log(1, "Resource is missing an identity capability (osgi.identity).");
            return false;
        }
        if ("osgi.core".equals(identity)) {
            return false;
        }
        return !identity.startsWith("ee.");
    }

    protected static Capability findFrameworkContractCapability(Resource resource) {
        List contractCaps = resource.getCapabilities("osgi.contract");
        if (contractCaps != null) {
            for (Capability cap : contractCaps) {
                if (!CONTRACT_OSGI_FRAMEWORK.equals(cap.getAttributes().get("osgi.contract"))) continue;
                return cap;
            }
        }
        return null;
    }

    private static CacheKey getCacheKey(Requirement requirement) {
        return new CacheKey(requirement.getNamespace(), requirement.getDirectives(), requirement.getAttributes(), requirement.getResource());
    }

    static Version getVersion(Capability cap, String attr) {
        Object versionatt = cap.getAttributes().get(attr);
        if (versionatt instanceof Version) {
            return (Version)versionatt;
        }
        if (versionatt instanceof String) {
            return Version.parseVersion((String)((String)versionatt));
        }
        return Version.emptyVersion;
    }

    public Resource getInputResource() {
        return this.inputResource;
    }

    public void setInputResource(Resource inputResource) {
        this.inputResource = inputResource;
    }

    public Resource getSystemResource() {
        return this.systemResource;
    }

    public void setSystemResource(Resource system) {
        this.systemResource = system;
    }

    public void addEffectiveDirective(String effectiveDirective) {
        this.effectiveSet.put(effectiveDirective, new HashSet());
    }

    public void addEffectiveDirective(String effectiveDirective, Set<String> excludedNamespaces) {
        this.effectiveSet.put(effectiveDirective, excludedNamespaces != null ? excludedNamespaces : new HashSet());
    }

    public void addEffectiveSet(Map<String, Set<String>> effectiveSet) {
        this.effectiveSet.putAll(effectiveSet);
    }

    protected void postProcessProviders(Requirement requirement, Set<Capability> wired, List<Capability> candidates) {
        if (candidates.size() == 0) {
            return;
        }
        for (ResolverHook resolverHook : this.resolverHooks) {
            resolverHook.filterMatches(requirement, candidates);
        }
        for (ResolutionCallback callback : this.callbacks) {
            callback.processCandidates(requirement, wired, candidates);
        }
    }

    public void addResolverHook(ResolverHook resolverHook) {
        this.resolverHooks.add(resolverHook);
    }

    public void addCallbacks(Collection<ResolutionCallback> callbacks) {
        this.callbacks.addAll(callbacks);
    }

    public static Requirement createIdentityRequirement(String identity, String versionRange) {
        aQute.libg.filters.Filter filter = new SimpleFilter("osgi.identity", identity);
        if (versionRange != null) {
            filter = new AndFilter().addChild(filter).addChild(new LiteralFilter(Filters.fromVersionRange((String)versionRange)));
        }
        Requirement frameworkReq = new CapReqBuilder("osgi.identity").addDirective("filter", filter.toString()).buildSyntheticRequirement();
        return frameworkReq;
    }

    public boolean isInputResource(Resource resource) {
        return AbstractResolveContext.resourceIdentityEquals(resource, this.inputResource);
    }

    public boolean isSystemResource(Resource resource) {
        return AbstractResolveContext.resourceIdentityEquals(resource, this.systemResource);
    }

    public Resource getHighestResource(String bsn, String range) {
        List<Resource> resources = this.getResources(this.getRepositories(), bsn, range);
        if (resources.isEmpty()) {
            return null;
        }
        Collections.sort(resources, Collections.reverseOrder(ResourceUtils.IDENTITY_VERSION_COMPARATOR));
        return resources.get(0);
    }

    public List<Resource> getResources(List<Repository> repos, String bsn, String range) {
        Requirement bundle = CapReqBuilder.createBundleRequirement((String)bsn, (String)range).buildSyntheticRequirement();
        return this.getResources(repos, bundle);
    }

    public List<Resource> getResources(List<Repository> repos, Requirement req) {
        HashSet resources = new HashSet();
        for (Repository repo : repos) {
            Collection<Capability> providers = this.findProviders(repo, req);
            resources.addAll(ResourceUtils.getResources(providers));
        }
        return new ArrayList<Resource>(resources);
    }

    protected void setFramework(ResourceBuilder system, Resource framework) throws Exception {
        system.addCapabilities(framework.getCapabilities(null));
        CapReqBuilder cap = new CapReqBuilder("osgi.wiring.bundle");
        cap.addAttribute("osgi.wiring.bundle", (Object)"system.bundle");
        String frameworkVersion = ResourceUtils.getIdentityVersion((Resource)framework);
        cap.addAttribute("bundle-version", (Object)frameworkVersion);
        system.addCapability(cap);
        cap = new CapReqBuilder("osgi.wiring.host");
        cap.addAttribute("osgi.wiring.host", (Object)"system.bundle");
        cap.addAttribute("bundle-version", (Object)frameworkVersion);
        system.addCapability(cap);
        this.framework = framework;
    }

    protected void addSystemResource(ResourceBuilder system, Resource resource) throws Exception {
        system.copyCapabilities(IGNORED_NAMESPACES_FOR_SYSTEM_RESOURCES, resource);
    }

    protected static Version toVersion(Object object) throws IllegalArgumentException {
        if (object == null) {
            return null;
        }
        if (object instanceof Version) {
            return (Version)object;
        }
        if (object instanceof String) {
            return Version.parseVersion((String)((String)object));
        }
        throw new IllegalArgumentException(MessageFormat.format("Cannot convert type {0} to Version.", object.getClass().getName()));
    }

    public static Repository createRepository(final List<Resource> resources) {
        return new Repository(){

            public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
                LinkedHashMap reqMap = null;
                for (Requirement requirement : requirements) {
                    Resource resource = requirement.getResource();
                    ArrayList<Capability> result = new ArrayList<Capability>();
                    for (Resource found : resources) {
                        String filterStr = (String)requirement.getDirectives().get("filter");
                        try {
                            Filter filter = filterStr != null ? FrameworkUtil.createFilter((String)filterStr) : null;
                            List caps = found.getCapabilities(requirement.getNamespace());
                            for (Capability c : caps) {
                                if (filter == null || !filter.matches(c.getAttributes())) continue;
                                result.add(c);
                            }
                        }
                        catch (InvalidSyntaxException e) {
                        }
                    }
                    if (result.size() <= 0) continue;
                    if (reqMap == null) {
                        reqMap = new LinkedHashMap();
                    }
                    reqMap.put(requirement, result);
                }
                if (reqMap != null) {
                    return reqMap;
                }
                return Collections.emptyMap();
            }
        };
    }

    public static Capability createPackageCapability(String packageName, String versionString) throws Exception {
        CapReqBuilder builder = new CapReqBuilder("osgi.wiring.package");
        builder.addAttribute("osgi.wiring.package", (Object)packageName);
        Version version = versionString != null ? new Version(versionString) : Version.emptyVersion;
        builder.addAttribute("version", (Object)version);
        return builder.buildSyntheticCapability();
    }

    public static boolean resourceIdentityEquals(Resource r1, Resource r2) {
        String id1 = AbstractResolveContext.getResourceIdentity(r1);
        String id2 = AbstractResolveContext.getResourceIdentity(r2);
        if (id1 != null && id1.equals(id2)) {
            Version v1 = AbstractResolveContext.getResourceVersion(r1);
            Version v2 = AbstractResolveContext.getResourceVersion(r2);
            if (v1 == null && v2 == null || v1 != null && v1.equals((Object)v2)) {
                return true;
            }
        }
        return false;
    }

    public static Capability getIdentityCapability(Resource resource) {
        if (resource == null) {
            return null;
        }
        List identityCaps = resource.getCapabilities("osgi.identity");
        if (identityCaps == null || identityCaps.isEmpty()) {
            return null;
        }
        return (Capability)identityCaps.iterator().next();
    }

    public static String getResourceIdentity(Resource resource) {
        Capability cap = AbstractResolveContext.getIdentityCapability(resource);
        if (cap == null) {
            return null;
        }
        return (String)cap.getAttributes().get("osgi.identity");
    }

    public static Version getResourceVersion(Resource resource) {
        Capability cap = AbstractResolveContext.getIdentityCapability(resource);
        if (cap == null) {
            return null;
        }
        return AbstractResolveContext.getVersion(cap, "version");
    }

    protected void setBlackList(Collection<Requirement> reject) {
        for (Repository repo : this.repositories) {
            Map caps = repo.findProviders(reject);
            for (Map.Entry entry : caps.entrySet()) {
                for (Capability cap : (Collection)entry.getValue()) {
                    this.blacklistedResources.add(cap.getResource());
                }
            }
        }
    }

    public List<ResolutionCallback> getCallbacks() {
        return this.callbacks;
    }

    public Set<Resource> getBlackList() {
        return this.blacklistedResources;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getLevel() {
        return this.level;
    }

    public Resource getFramework() {
        return this.framework;
    }

    public void loadPath(ResourceBuilder system, String path, String what) throws IOException, Exception {
        Parameters p = new Parameters(path);
        if (p.isEmpty()) {
            return;
        }
        for (Map.Entry e : p.entrySet()) {
            Resource resource;
            block35: {
                String bsn = Processor.removeDuplicateMarker((String)((String)e.getKey()));
                String version = ((Attrs)e.getValue()).getVersion();
                if ("latest".equals(version) || "snapshot".equals(version)) {
                    version = null;
                }
                if ("file".equals(version)) {
                    File f = IO.getFile(bsn);
                    if (f.isFile()) {
                        FileInputStream fin = new FileInputStream(f);
                        Throwable throwable = null;
                        try {
                            Manifest m;
                            if (f.getName().endsWith(".mf")) {
                                m = new Manifest(fin);
                            } else {
                                try (JarInputStream jin = new JarInputStream(fin);){
                                    m = jin.getManifest();
                                }
                            }
                            if (m == null) continue;
                            ResourceBuilder rb = new ResourceBuilder();
                            rb.addManifest(Domain.domain((Manifest)m));
                            resource = rb.build();
                            break block35;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (fin == null) continue;
                            if (throwable != null) {
                                try {
                                    fin.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            fin.close();
                            continue;
                        }
                    }
                    this.log.log(1, "Found fileresource " + bsn + ";" + version + " but file does not exist");
                    continue;
                }
                if (version == null || VersionRange.isVersionRange((String)version)) {
                    resource = this.getHighestResource(bsn, version);
                    if (resource == null) {
                        this.log.log(1, "Could not find resource " + bsn + ";" + version);
                    }
                } else {
                    this.log.log(1, "Cannot find resource " + bsn + ";" + version);
                    continue;
                }
            }
            this.addSystemResource(system, resource);
        }
    }

    public void setInputRequirements(Requirement ... reqs) throws Exception {
        ResourceBuilder rb = new ResourceBuilder();
        for (Requirement r : reqs) {
            rb.addRequirement(r);
        }
        this.setInputResource(rb.build());
    }

    public Map<String, Set<String>> getEffectiveSet() {
        return this.effectiveSet;
    }

    static {
        IGNORED_NAMESPACES_FOR_SYSTEM_RESOURCES.add("osgi.identity");
        IGNORED_NAMESPACES_FOR_SYSTEM_RESOURCES.add("osgi.content");
    }

    private class CapabilityComparator
    implements Comparator<Capability> {
        private final LogService log;

        public CapabilityComparator(LogService log) {
            this.log = log;
        }

        @Override
        public int compare(Capability o1, Capability o2) {
            int diff;
            Version v2;
            Version v1;
            String ns2;
            Resource res1 = o1.getResource();
            Resource res2 = o2.getResource();
            if (AbstractResolveContext.this.isSystemResource(res1)) {
                return -1;
            }
            if (AbstractResolveContext.this.isSystemResource(res2)) {
                return 1;
            }
            Map<Resource, Wiring> wirings = AbstractResolveContext.this.getWirings();
            Wiring w1 = wirings.get(res1);
            Wiring w2 = wirings.get(res2);
            if (w1 != null && w2 == null) {
                return -1;
            }
            if (w1 == null && w2 != null) {
                return 1;
            }
            if (AbstractResolveContext.this.isInputResource(res1) && !AbstractResolveContext.this.isInputResource(res2)) {
                return -1;
            }
            if (AbstractResolveContext.this.isInputResource(res2) && !AbstractResolveContext.this.isInputResource(res1)) {
                return 1;
            }
            String ns1 = o1.getNamespace();
            if (ns1 == (ns2 = o2.getNamespace()) || ns1 != null && ns1.equals(ns2)) {
                try {
                    v1 = AbstractResolveContext.getVersion(o1, "version");
                    v2 = AbstractResolveContext.getVersion(o2, "version");
                    if (!v1.equals((Object)v2)) {
                        return v2.compareTo(v1);
                    }
                }
                catch (Exception e) {
                    this.log.log(3, "Unable to determine the versions of the capabilities " + o1 + " and " + o2, e);
                }
            }
            if ("osgi.wiring.bundle".equals(ns1) && "osgi.wiring.bundle".equals(ns2) ? !(v1 = AbstractResolveContext.getVersion(o1, "bundle-version")).equals((Object)(v2 = AbstractResolveContext.getVersion(o2, "bundle-version"))) : "osgi.identity".equals(ns1) && "osgi.identity".equals(ns2) && !(v1 = AbstractResolveContext.getVersion(o1, "version")).equals((Object)(v2 = AbstractResolveContext.getVersion(o2, "version")))) {
                return v2.compareTo(v1);
            }
            if ("osgi.wiring.package".equals(ns1) && "osgi.wiring.package".equals(ns2)) {
                Version v22;
                Version v12;
                String bsn1 = (String)o1.getAttributes().get("bundle-symbolic-name");
                String bsn2 = (String)o2.getAttributes().get("bundle-symbolic-name");
                if (bsn1 != null && bsn1.equals(bsn2) && !(v12 = AbstractResolveContext.getVersion(o1, "bundle-version")).equals((Object)(v22 = AbstractResolveContext.getVersion(o2, "bundle-version")))) {
                    return v22.compareTo(v12);
                }
            }
            if ((diff = res1.getRequirements(null).size() - res2.getRequirements(null).size()) != 0) {
                return diff;
            }
            return res2.getCapabilities(null).size() - res1.getCapabilities(null).size();
        }
    }

    private static class CacheKey {
        final String namespace;
        final Map<String, String> directives;
        final Map<String, Object> attributes;
        final Resource resource;
        final int hashcode;

        CacheKey(String namespace, Map<String, String> directives, Map<String, Object> attributes, Resource resource) {
            this.namespace = namespace;
            this.directives = directives;
            this.attributes = attributes;
            this.resource = resource;
            this.hashcode = CacheKey.calculateHashCode(namespace, directives, attributes, resource);
        }

        private static int calculateHashCode(String namespace, Map<String, String> directives, Map<String, Object> attributes, Resource resource) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (attributes == null ? 0 : attributes.hashCode());
            result = 31 * result + (directives == null ? 0 : directives.hashCode());
            result = 31 * result + (namespace == null ? 0 : namespace.hashCode());
            result = 31 * result + (resource == null ? 0 : resource.hashCode());
            return result;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
                return false;
            }
            if (this.directives == null ? other.directives != null : !this.directives.equals(other.directives)) {
                return false;
            }
            if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
                return false;
            }
            return !(this.resource == null ? other.resource != null : !AbstractResolveContext.resourceIdentityEquals(this.resource, other.resource));
        }
    }
}

