/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.io;

import aQute.libg.glob.Glob;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;

public class IO {
    static final int BUFFER_SIZE = 65536;
    public static final File work = new File(System.getProperty("user.dir"));
    public static final File home;
    public static OutputStream nullStream;
    public static Writer nullWriter;
    static final Pattern RESERVED_WINDOWS_P;

    public static String getExtension(String fileName, String deflt) {
        int n = fileName.lastIndexOf(46);
        if (n < 0) {
            return deflt;
        }
        return fileName.substring(n + 1);
    }

    public static Collection<File> tree(File current) {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        IO.traverse(files, current, null);
        return files;
    }

    public static Collection<File> tree(File current, String glob) {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        IO.traverse(files, current, glob == null ? null : new Glob(glob));
        return files;
    }

    private static void traverse(Collection<File> files, File current, Glob glob) {
        if (current.isFile() && (glob == null || glob.matcher(current.getName()).matches())) {
            files.add(current);
        } else if (current.isDirectory()) {
            for (File sub : current.listFiles()) {
                IO.traverse(files, sub, glob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader r, Writer w) throws IOException {
        try {
            char[] buffer = new char[65536];
            int size = r.read(buffer);
            while (size > 0) {
                w.write(buffer, 0, size);
                size = r.read(buffer);
            }
        }
        finally {
            r.close();
            w.flush();
        }
    }

    public static void copy(InputStream r, Writer w) throws IOException {
        IO.copy(r, w, "UTF-8");
    }

    public static void copy(byte[] r, Writer w) throws IOException {
        IO.copy((InputStream)new ByteArrayInputStream(r), w, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(byte[] data, File file) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            IO.copy(data, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    public static void copy(byte[] r, OutputStream w) throws IOException {
        IO.copy((InputStream)new ByteArrayInputStream(r), w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream r, Writer w, String charset) throws IOException {
        try {
            InputStreamReader isr = new InputStreamReader(r, charset);
            IO.copy((Reader)isr, w);
        }
        finally {
            r.close();
        }
    }

    public static void copy(Reader r, OutputStream o) throws IOException {
        IO.copy(r, o, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader r, OutputStream o, String charset) throws IOException {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(o, charset);
            IO.copy(r, (Writer)osw);
        }
        finally {
            r.close();
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        IO.copy(in, dos);
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, DataOutput out) throws IOException {
        byte[] buffer = new byte[65536];
        try {
            int size = in.read(buffer);
            while (size > 0) {
                out.write(buffer, 0, size);
                size = in.read(buffer);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, ByteBuffer bb) throws IOException {
        byte[] buffer = new byte[65536];
        try {
            int size = in.read(buffer);
            while (size > 0) {
                bb.put(buffer, 0, size);
                size = in.read(buffer);
            }
        }
        finally {
            in.close();
        }
    }

    public static void copy(URL in, MessageDigest md) throws IOException {
        IO.copy(in.openStream(), md);
    }

    public static void copy(File in, MessageDigest md) throws IOException {
        IO.copy((InputStream)new FileInputStream(in), md);
    }

    public static void copy(URLConnection in, MessageDigest md) throws IOException {
        IO.copy(in.getInputStream(), md);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, MessageDigest md) throws IOException {
        byte[] buffer = new byte[65536];
        try {
            int size = in.read(buffer);
            while (size > 0) {
                md.update(buffer, 0, size);
                size = in.read(buffer);
            }
        }
        finally {
            in.close();
        }
    }

    public static void copy(URL url, File file) throws IOException {
        URLConnection c = url.openConnection();
        IO.copy(c, file);
    }

    public static void copy(URLConnection c, File file) throws IOException {
        IO.copy(c.getInputStream(), file);
    }

    public static void copy(InputStream in, URL out) throws IOException {
        IO.copy(in, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, URL out, String method) throws IOException {
        URLConnection c = out.openConnection();
        if (c instanceof HttpURLConnection && method != null) {
            HttpURLConnection http = (HttpURLConnection)c;
            http.setRequestMethod(method);
        }
        c.setDoOutput(true);
        OutputStream os = c.getOutputStream();
        try {
            IO.copy(in, os);
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File a, File b) throws IOException {
        if (a.isFile()) {
            FileOutputStream out = new FileOutputStream(b);
            try {
                IO.copy((InputStream)new FileInputStream(a), (OutputStream)out);
            }
            finally {
                out.close();
            }
        } else if (a.isDirectory()) {
            File[] subs;
            if (!b.exists() && !b.mkdirs()) {
                throw new IOException("Could not create directory " + b);
            }
            if (!b.isDirectory()) {
                throw new IllegalArgumentException("target directory for a directory must be a directory: " + b);
            }
            for (File sub : subs = a.listFiles()) {
                IO.copy(sub, new File(b, sub.getName()));
            }
        } else {
            throw new FileNotFoundException("During copy: " + ((Object)a).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream a, File b) throws IOException {
        FileOutputStream out = new FileOutputStream(b);
        try {
            IO.copy(a, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    public static void copy(File a, OutputStream b) throws IOException {
        IO.copy((InputStream)new FileInputStream(a), b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File f) throws IOException {
        byte[] data = new byte[(int)f.length()];
        DataInputStream in = new DataInputStream(new FileInputStream(f));
        try {
            in.readFully(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static byte[] read(URL u) throws IOException {
        return IO.read(u.openStream());
    }

    public static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        IO.copy(in, (OutputStream)bout);
        return bout.toByteArray();
    }

    public static void write(byte[] data, OutputStream out) throws Exception {
        IO.copy((InputStream)new ByteArrayInputStream(data), out);
    }

    public static void write(byte[] data, File out) throws Exception {
        IO.copy((InputStream)new ByteArrayInputStream(data), out);
    }

    public static String collect(File a, String encoding) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(a, (OutputStream)out);
        return new String(out.toByteArray(), encoding);
    }

    public static String collect(URL a, String encoding) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(a.openStream(), (OutputStream)out);
        return new String(out.toByteArray(), encoding);
    }

    public static String collect(URL a) throws IOException {
        return IO.collect(a, "UTF-8");
    }

    public static String collect(File a) throws IOException {
        return IO.collect(a, "UTF-8");
    }

    public static String collect(String a) throws IOException {
        return IO.collect(new File(a), "UTF-8");
    }

    public static String collect(InputStream a, String encoding) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(a, (OutputStream)out);
        return new String(out.toByteArray(), encoding);
    }

    public static String collect(InputStream a) throws IOException {
        return IO.collect(a, "UTF-8");
    }

    public static String collect(Reader a) throws IOException {
        StringWriter sw = new StringWriter();
        char[] buffer = new char[65536];
        int size = a.read(buffer);
        while (size > 0) {
            sw.write(buffer, 0, size);
            size = a.read(buffer);
        }
        return ((Object)sw).toString();
    }

    public static File createTempFile(File directory, String pattern, String suffix) throws IllegalArgumentException, IOException {
        if (pattern == null || pattern.length() < 3) {
            throw new IllegalArgumentException("Pattern must be at least 3 characters long, got " + (pattern == null ? "null" : Integer.valueOf(pattern.length())));
        }
        if (directory != null && !directory.isDirectory()) {
            throw new FileNotFoundException("Directory " + directory + " is not a directory");
        }
        return File.createTempFile(pattern, suffix, directory);
    }

    public static File getFile(String filename) {
        return IO.getFile(work, filename);
    }

    public static File getFile(File base, String file) {
        int n;
        if (file.startsWith("~/") && !(file = file.substring(2)).startsWith("~/")) {
            return IO.getFile(home, file);
        }
        if (file.startsWith("~")) {
            file = file.substring(1);
            return IO.getFile(home.getParentFile(), file);
        }
        File f = new File(file);
        if (f.isAbsolute()) {
            return f;
        }
        if (base == null) {
            base = work;
        }
        f = base.getAbsoluteFile();
        while ((n = file.indexOf(47)) > 0) {
            String first = file.substring(0, n);
            file = file.substring(n + 1);
            if (first.equals("..")) {
                f = f.getParentFile();
                continue;
            }
            f = new File(f, first);
        }
        if (file.equals("..")) {
            return f.getParentFile();
        }
        return new File(f, file).getAbsoluteFile();
    }

    public static void delete(File f) {
        try {
            IO.deleteWithException(f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void initialize(File f) {
        try {
            IO.deleteWithException(f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        f.mkdirs();
    }

    public static void deleteWithException(File f) throws IOException {
        boolean fDeleted;
        if (!(f = f.getAbsoluteFile()).exists()) {
            if (IO.isSymbolicLink(f)) {
                f.delete();
            }
            return;
        }
        if (f.getParentFile() == null) {
            throw new IllegalArgumentException("Cannot recursively delete root for safety reasons");
        }
        boolean wasDeleted = true;
        if (f.isDirectory()) {
            File[] subs;
            for (File sub : subs = f.listFiles()) {
                try {
                    IO.deleteWithException(sub);
                }
                catch (IOException e) {
                    wasDeleted = false;
                }
            }
        }
        if (!(fDeleted = f.delete()) || !wasDeleted) {
            throw new IOException("Failed to delete " + f.getAbsoluteFile());
        }
    }

    public static void rename(File from, File to) throws IOException {
        IO.deleteWithException(to);
        boolean renamed = from.renameTo(to);
        if (!renamed) {
            throw new IOException("Could not rename " + from.getAbsoluteFile() + " to " + to.getAbsoluteFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long drain(InputStream in) throws IOException {
        long result = 0L;
        byte[] buffer = new byte[65536];
        try {
            int size = in.read(buffer);
            while (size >= 0) {
                result += (long)size;
                size = in.read(buffer);
            }
        }
        finally {
            in.close();
        }
        return result;
    }

    public void copy(Collection<?> c, OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");
        PrintWriter ps = new PrintWriter(w);
        for (Object o : c) {
            ps.println(o);
        }
        ps.flush();
        ((Writer)w).flush();
    }

    public static Throwable close(Closeable in) {
        if (in == null) {
            return null;
        }
        try {
            in.close();
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    public static URL toURL(String s, File base) throws MalformedURLException {
        int n = s.indexOf(58);
        if (n > 0 && n < 10) {
            return new URL(s);
        }
        return IO.getFile(base, s).toURI().toURL();
    }

    public static void store(Object o, File out) throws IOException {
        IO.store(o, out, "UTF-8");
    }

    public static void store(Object o, File out, String encoding) throws IOException {
        IO.store(o, new FileOutputStream(out), encoding);
    }

    public static void store(Object o, OutputStream fout) throws IOException {
        IO.store(o, fout, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Object o, OutputStream fout, String encoding) throws IOException {
        try {
            String s = o == null ? "" : o.toString();
            fout.write(s.getBytes(encoding));
        }
        finally {
            fout.close();
        }
    }

    public static InputStream stream(String s) {
        try {
            return new ByteArrayInputStream(s.getBytes("UTF-8"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static InputStream stream(String s, String encoding) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(s.getBytes(encoding));
    }

    public static InputStream stream(File s) throws FileNotFoundException {
        return new FileInputStream(s);
    }

    public static InputStream stream(URL s) throws IOException {
        return s.openStream();
    }

    public static Reader reader(String s) {
        return new StringReader(s);
    }

    public static BufferedReader reader(File f, String encoding) throws IOException {
        return IO.reader(new FileInputStream(f), encoding);
    }

    public static BufferedReader reader(File f) throws IOException {
        return IO.reader(f, "UTF-8");
    }

    public static PrintWriter writer(File f, String encoding) throws IOException {
        return IO.writer(new FileOutputStream(f), encoding);
    }

    public static PrintWriter writer(File f) throws IOException {
        return IO.writer(f, "UTF-8");
    }

    public static PrintWriter writer(OutputStream out, String encoding) throws IOException {
        return new PrintWriter(new OutputStreamWriter(out, encoding));
    }

    public static BufferedReader reader(InputStream in, String encoding) throws IOException {
        return new BufferedReader(new InputStreamReader(in, encoding));
    }

    public static BufferedReader reader(InputStream in) throws IOException {
        return IO.reader(in, "UTF-8");
    }

    public static PrintWriter writer(OutputStream out) throws IOException {
        return IO.writer(out, "UTF-8");
    }

    public static boolean createSymbolicLink(File link, File target) throws Exception {
        try {
            Method toPath = link.getClass().getMethod("toPath", new Class[0]);
            Class<?> Files = Class.forName("java.nio.file.Files");
            for (Method m : Files.getMethods()) {
                if (!m.getName().equals("createSymbolicLink") || m.getParameterTypes().length != 3) continue;
                Object attrs = Array.newInstance(m.getParameterTypes()[2].getComponentType(), 0);
                m.invoke(null, toPath.invoke((Object)link, new Object[0]), toPath.invoke((Object)target, new Object[0]), attrs);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isSymbolicLink(File link) {
        try {
            Method toPath = link.getClass().getMethod("toPath", new Class[0]);
            Class<?> Files = Class.forName("java.nio.file.Files");
            Method method = Files.getMethod("isSymbolicLink", toPath.getReturnType());
            return (Boolean)method.invoke(null, toPath.invoke((Object)link, new Object[0]));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String toSafeFileName(String string) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ') continue;
            if (IO.isWindows()) {
                switch (c) {
                    case '\"': 
                    case '*': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '\\': 
                    case '|': {
                        sb.append('%');
                        break;
                    }
                    default: {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '/': {
                    sb.append('%');
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() == 0 || IO.isWindows() && RESERVED_WINDOWS_P.matcher(sb).matches()) {
            sb.append("_");
        }
        return sb.toString();
    }

    static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    static {
        File tmp = null;
        try {
            tmp = new File(System.getenv("HOME"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tmp == null) {
            tmp = new File(System.getProperty("user.home"));
        }
        home = tmp;
        nullStream = new OutputStream(){

            @Override
            public void write(int var0) throws IOException {
            }

            @Override
            public void write(byte[] var0) throws IOException {
            }

            @Override
            public void write(byte[] var0, int from, int l) throws IOException {
            }
        };
        nullWriter = new Writer(){

            @Override
            public Writer append(char var0) throws IOException {
                return null;
            }

            @Override
            public Writer append(CharSequence var0) throws IOException {
                return null;
            }

            @Override
            public Writer append(CharSequence var0, int var1, int var2) throws IOException {
                return null;
            }

            @Override
            public void write(int var0) throws IOException {
            }

            @Override
            public void write(String var0) throws IOException {
            }

            @Override
            public void write(String var0, int var1, int var2) throws IOException {
            }

            @Override
            public void write(char[] var0) throws IOException {
            }

            @Override
            public void write(char[] var0, int var1, int var2) throws IOException {
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }
        };
        RESERVED_WINDOWS_P = Pattern.compile("CON|PRN|AUX|NUL|COM1|COM2|COM3|COM4|COM5|COM6|COM7|COM8|COM9|LPT1|LPT2|LPT3|LPT4|LPT5|LPT6|LPT7|LPT8|LPT9");
    }
}

