/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.model.xml.PagesDomModelManager;
import com.intellij.seam.model.xml.PagesModel;
import com.intellij.seam.model.xml.PagesModelFactory;
import com.intellij.seam.model.xml.pages.Pages;
import com.intellij.util.xml.DomManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PagesDomModelManagerImpl
extends PagesDomModelManager {
    private final PagesModelFactory myModelFactory;
    private final DomManager myDomManager;

    public PagesDomModelManagerImpl(Project project) {
        this.myModelFactory = new PagesModelFactory(project);
        this.myDomManager = DomManager.getDomManager((Project)project);
    }

    @Override
    public boolean isPages(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/seam/impl/PagesDomModelManagerImpl", "isPages"));
        }
        return this.myDomManager.getFileElement(file, Pages.class) != null;
    }

    @Override
    public PagesModel getPagesModel(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/seam/impl/PagesDomModelManagerImpl", "getPagesModel"));
        }
        return this.myModelFactory.getModelByConfigFile(file);
    }

    @Override
    public List<PagesModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/seam/impl/PagesDomModelManagerImpl", "getAllModels"));
        }
        return this.myModelFactory.getAllModels((UserDataHolder)module);
    }
}

