/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.graph.beans;

import com.intellij.seam.graph.beans.BasicPagesNode;
import com.intellij.seam.model.xml.pages.PagesViewIdOwner;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NotNull;

public abstract class BasicPagesEdge<T extends DomElement> {
    private final BasicPagesNode mySource;
    private final BasicPagesNode myTarget;
    private final PagesViewIdOwner myViewId;
    private final T myParentElement;

    public BasicPagesNode getSource() {
        return this.mySource;
    }

    public BasicPagesNode getTarget() {
        return this.myTarget;
    }

    public BasicPagesEdge(@NotNull BasicPagesNode source, @NotNull BasicPagesNode target, PagesViewIdOwner redirect, @NotNull T parentElement) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/seam/graph/beans/BasicPagesEdge", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/seam/graph/beans/BasicPagesEdge", "<init>"));
        }
        if (parentElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentElement", "com/intellij/seam/graph/beans/BasicPagesEdge", "<init>"));
        }
        this.mySource = source;
        this.myTarget = target;
        this.myViewId = (PagesViewIdOwner)redirect.createStableCopy();
        this.myParentElement = parentElement.createStableCopy();
    }

    public String getName() {
        return "";
    }

    public PagesViewIdOwner getViewId() {
        return this.myViewId;
    }

    public T getParentElement() {
        return this.myParentElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicPagesEdge that = (BasicPagesEdge)o;
        if (!this.myViewId.equals(that.myViewId)) {
            return false;
        }
        if (!this.mySource.equals(that.mySource)) {
            return false;
        }
        return this.myTarget.equals(that.myTarget);
    }

    public int hashCode() {
        int result = this.mySource.hashCode();
        result = 31 * result + this.myTarget.hashCode();
        result = 31 * result + this.myViewId.hashCode();
        return result;
    }
}

