/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.graph;

import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.components.SelectionDependenciesPresentationModel;
import com.intellij.openapi.graph.builder.renderer.BasicGraphNodeRenderer;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PolyLineEdgeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.seam.graph.beans.BasicPagesEdge;
import com.intellij.seam.graph.beans.BasicPagesNode;
import com.intellij.seam.graph.beans.ExceptionEdge;
import com.intellij.seam.graph.beans.ExceptionNode;
import com.intellij.seam.graph.beans.PageNode;
import com.intellij.seam.graph.renderers.DefaultPagesNodeRenderer;
import com.intellij.util.OpenSourceUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PagesPresentationModel
extends SelectionDependenciesPresentationModel<BasicPagesNode, BasicPagesEdge> {
    private final Project myProject;
    private BasicGraphNodeRenderer myRenderer;

    public PagesPresentationModel(Graph2D graph, Project project) {
        super((Graph)graph);
        this.myProject = project;
        this.setShowEdgeLabels(false);
    }

    @NotNull
    public NodeRealizer getNodeRealizer(BasicPagesNode node) {
        NodeRealizer nodeRealizer = GraphViewUtil.createNodeRealizer((String)"PagesNodeRenderer", (NodeCellRenderer)this.getRenderer());
        if (nodeRealizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/graph/PagesPresentationModel", "getNodeRealizer"));
        }
        return nodeRealizer;
    }

    public BasicGraphNodeRenderer getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new DefaultPagesNodeRenderer((GraphBuilder<BasicPagesNode, BasicPagesEdge>)this.getGraphBuilder());
        }
        return this.myRenderer;
    }

    @NotNull
    public EdgeRealizer getEdgeRealizer(BasicPagesEdge edge) {
        PolyLineEdgeRealizer edgeRealizer = GraphManager.getGraphManager().createPolyLineEdgeRealizer();
        boolean isExceptionEdge = edge instanceof ExceptionEdge;
        edgeRealizer.setLineType(isExceptionEdge ? LineType.DASHED_1 : LineType.LINE_1);
        edgeRealizer.setArrow(isExceptionEdge ? Arrow.DELTA : Arrow.STANDARD);
        edgeRealizer.setLineColor(Color.GRAY);
        PolyLineEdgeRealizer polyLineEdgeRealizer = edgeRealizer;
        if (polyLineEdgeRealizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/graph/PagesPresentationModel", "getEdgeRealizer"));
        }
        return polyLineEdgeRealizer;
    }

    public boolean editNode(BasicPagesNode node) {
        XmlElement xmlElement = node.getIdentifyingElement().getXmlElement();
        if (xmlElement instanceof Navigatable) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)xmlElement});
            return true;
        }
        return super.editNode((Object)node);
    }

    public boolean editEdge(BasicPagesEdge pagesEdge) {
        XmlElement xmlElement = pagesEdge.getViewId().getXmlElement();
        if (xmlElement instanceof Navigatable) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)xmlElement});
            return true;
        }
        return super.editEdge((Object)pagesEdge);
    }

    public Project getProject() {
        return this.myProject;
    }

    public String getNodeTooltip(BasicPagesNode node) {
        return node.getName();
    }

    public String getEdgeTooltip(BasicPagesEdge edge) {
        return edge.getName();
    }

    public void customizeSettings(Graph2DView view, EditMode editMode) {
        editMode.allowEdgeCreation(true);
        editMode.allowBendCreation(false);
        view.setFitContentOnResize(false);
        view.fitContent();
    }

    public DeleteProvider getDeleteProvider() {
        return new DeleteProvider<BasicPagesNode, BasicPagesEdge>(){

            public boolean canDeleteNode(@NotNull BasicPagesNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/seam/graph/PagesPresentationModel$1", "canDeleteNode"));
                }
                return !((CellEditorMode)PagesPresentationModel.this.getGraphBuilder().getEditMode().getEditNodeMode()).isCellEditing();
            }

            public boolean canDeleteEdge(@NotNull BasicPagesEdge edge) {
                if (edge == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/seam/graph/PagesPresentationModel$1", "canDeleteEdge"));
                }
                return true;
            }

            public boolean deleteNode(final @NotNull BasicPagesNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/seam/graph/PagesPresentationModel$1", "deleteNode"));
                }
                Collection edges = PagesPresentationModel.this.getGraphBuilder().getEdgeObjects();
                final ArrayList<BasicPagesEdge> deleteThis = new ArrayList<BasicPagesEdge>();
                for (BasicPagesEdge edge : edges) {
                    if (!edge.getSource().equals(node) && !edge.getTarget().equals(node)) continue;
                    deleteThis.add(edge);
                }
                new WriteCommandAction(PagesPresentationModel.this.getProject(), new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/seam/graph/PagesPresentationModel$1$1", "run"));
                        }
                        node.getIdentifyingElement().undefine();
                        for (BasicPagesEdge edge : deleteThis) {
                            if (!edge.getViewId().isValid()) continue;
                            edge.getViewId().undefine();
                        }
                    }
                }.execute();
                return true;
            }

            public boolean deleteEdge(final @NotNull BasicPagesEdge edge) {
                if (edge == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/seam/graph/PagesPresentationModel$1", "deleteEdge"));
                }
                new WriteCommandAction(PagesPresentationModel.this.getProject(), new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/seam/graph/PagesPresentationModel$1$2", "run"));
                        }
                        edge.getViewId().undefine();
                    }
                }.execute();
                return true;
            }
        };
    }

    public NodeCellEditor getCustomNodeCellEditor(BasicPagesNode pagesNode) {
        return null;
    }

    public DefaultActionGroup getNodeActionGroup(BasicPagesNode pagesNode) {
        return super.getNodeActionGroup((Object)pagesNode);
    }

    public EdgeCreationPolicy<BasicPagesNode> getEdgeCreationPolicy() {
        return new EdgeCreationPolicy<BasicPagesNode>(){

            public boolean acceptSource(@NotNull BasicPagesNode source) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/seam/graph/PagesPresentationModel$2", "acceptSource"));
                }
                return source instanceof PageNode || source instanceof ExceptionNode;
            }

            public boolean acceptTarget(@NotNull BasicPagesNode target) {
                if (target == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/seam/graph/PagesPresentationModel$2", "acceptTarget"));
                }
                return !target.getName().contains("*") && !(target instanceof ExceptionNode);
            }
        };
    }
}

