/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.resolve.JavaMethodCandidateInfo;
import com.intellij.psi.resolve.JavaMethodResolveHelper;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.tapestry.psi.TapestryAccessorMethod;
import com.intellij.tapestry.psi.TelMethodCallExpression;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TelVariantsProcessor<T>
extends BaseScopeProcessor {
    @NonNls
    private static final THashSet<String> INSECURE_OBJECT_METHODS = new THashSet(Arrays.asList("wait", "notify", "notifyAll"));
    private final Set<T> myResult = new LinkedHashSet<T>();
    private final boolean myForCompletion;
    private final boolean myMethodCall;
    private final String myReferenceName;
    private final JavaMethodResolveHelper myPropertyAccessors;
    private final JavaMethodResolveHelper myMethods;
    private final boolean myAllowStatic;

    protected TelVariantsProcessor(@Nullable PsiElement parent, @Nullable String referenceName, boolean allowStatic) {
        this.myAllowStatic = allowStatic;
        this.myForCompletion = referenceName == null;
        this.myReferenceName = referenceName;
        this.myMethodCall = parent instanceof TelMethodCallExpression;
        if (this.myMethodCall && !this.myForCompletion) {
            PsiType[] parameterTypes = ((TelMethodCallExpression)parent).getArgumentTypes();
            this.myMethods = new JavaMethodResolveHelper(parent, parent.getContainingFile(), parameterTypes);
            this.myPropertyAccessors = null;
        } else {
            this.myMethods = this.myForCompletion ? new JavaMethodResolveHelper(parent, parent.getContainingFile(), null) : null;
            this.myPropertyAccessors = new JavaMethodResolveHelper(parent, parent.getContainingFile(), null);
        }
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/tapestry/psi/TelVariantsProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/tapestry/psi/TelVariantsProcessor", "execute"));
        }
        if (!(element instanceof PsiNamedElement)) {
            return true;
        }
        PsiNamedElement namedElement = (PsiNamedElement)element;
        if (StringUtil.isEmpty((String)namedElement.getName())) {
            return true;
        }
        if (namedElement instanceof PsiClass) {
            return true;
        }
        boolean isMethod = namedElement instanceof PsiMethod;
        boolean isField = namedElement instanceof PsiField;
        if (isMethod) {
            PsiMethod method = (PsiMethod)namedElement;
            if (!method.hasModifierProperty("public") || method.isConstructor() || !this.myAllowStatic && method.hasModifierProperty("static") || INSECURE_OBJECT_METHODS.contains((Object)method.getName())) {
                return true;
            }
            if (!this.myMethodCall && this.myPropertyAccessors != null && PropertyUtil.isSimplePropertyGetter((PsiMethod)method) && (this.myReferenceName == null || this.myReferenceName.equalsIgnoreCase(PropertyUtil.getPropertyName((PsiMethod)method)))) {
                this.myPropertyAccessors.addMethod(method, (PsiSubstitutor)state.get(PsiSubstitutor.KEY), false);
            }
            if ((this.myForCompletion || this.myMethodCall && this.myReferenceName.equalsIgnoreCase(namedElement.getName())) && this.myMethods != null) {
                this.myMethods.addMethod((PsiMethod)namedElement, (PsiSubstitutor)state.get(PsiSubstitutor.KEY), false);
            }
        } else if (isField) {
            PsiField field = (PsiField)namedElement;
            PsiModifierList modifierList = field.getModifierList();
            if (!field.hasModifierProperty("private") || modifierList == null || field.hasModifierProperty("static")) {
                return true;
            }
            String propertyAnnotation = null;
            for (PsiAnnotation psiAnnotation : modifierList.getAnnotations()) {
                if (!"org.apache.tapestry5.annotations.Property".equals(psiAnnotation.getQualifiedName())) continue;
                propertyAnnotation = psiAnnotation.getQualifiedName();
            }
            if (propertyAnnotation == null) {
                return true;
            }
            if (this.myForCompletion || !this.myMethodCall && this.myReferenceName.equalsIgnoreCase(namedElement.getName())) {
                ContainerUtil.addIfNotNull(this.myResult, this.createResult(namedElement, true));
            }
            String getterName = PropertyUtil.suggestGetterName((PsiField)field);
            if (this.myForCompletion || this.myMethodCall && this.myReferenceName.equalsIgnoreCase(getterName)) {
                this.myMethods.addMethod((PsiMethod)new TapestryAccessorMethod(field, true, getterName), (PsiSubstitutor)state.get(PsiSubstitutor.KEY), false);
            }
            String setterName = PropertyUtil.suggestSetterName((PsiField)field);
            if (!field.hasModifierProperty("final") && (this.myForCompletion || this.myMethodCall && this.myReferenceName.equalsIgnoreCase(setterName))) {
                this.myMethods.addMethod((PsiMethod)new TapestryAccessorMethod(field, false, setterName), (PsiSubstitutor)state.get(PsiSubstitutor.KEY), false);
            }
        }
        return this.myForCompletion || this.myResult.size() != 1;
    }

    @Nullable
    protected abstract T createResult(PsiNamedElement var1, boolean var2);

    @NotNull
    public T[] getVariants(T[] array) {
        if (this.myPropertyAccessors != null) {
            for (JavaMethodCandidateInfo methodCandidateInfo : this.myPropertyAccessors.getMethods()) {
                BeanProperty property = BeanProperty.createBeanProperty((PsiMethod)methodCandidateInfo.getMethod());
                if (property == null) continue;
                ContainerUtil.addIfNotNull(this.myResult, this.createResult(property.getPsiElement(), true));
            }
        }
        if (this.myMethods != null) {
            for (JavaMethodCandidateInfo methodCandidateInfo : this.myMethods.getMethods()) {
                boolean validResult = this.myMethods.getResolveError() == JavaMethodResolveHelper.ErrorType.NONE;
                ContainerUtil.addIfNotNull(this.myResult, this.createResult((PsiNamedElement)methodCandidateInfo.getMethod(), validResult));
            }
        }
        T[] TArray = this.myResult.toArray(array);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelVariantsProcessor", "getVariants"));
        }
        return TArray;
    }
}

