/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.tapestry.psi.TelCompositeElement;
import com.intellij.tapestry.psi.TelPsiUtil;
import com.intellij.tapestry.psi.TelQualifiedReference;
import com.intellij.tapestry.psi.TelReferenceQualifier;
import com.intellij.tapestry.psi.TelTokenTypes;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TelReferenceExpression
extends TelCompositeElement
implements TelReferenceQualifier {
    private final TelQualifiedReference myReference;

    protected TelReferenceExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/tapestry/psi/TelReferenceExpression", "<init>"));
        }
        super(node);
        this.myReference = new TelQualifiedReference(this){

            public TextRange getRangeInElement() {
                PsiElement element = TelReferenceExpression.this.getReferenceNameElement();
                if (element == null) {
                    return TextRange.from((int)0, (int)TelReferenceExpression.this.getTextLength());
                }
                return TextRange.from((int)element.getStartOffsetInParent(), (int)element.getTextLength());
            }

            @Override
            @Nullable
            public String getReferenceName() {
                PsiElement element = TelReferenceExpression.this.getReferenceNameElement();
                return element == null ? null : element.getText();
            }

            @Override
            @Nullable
            public TelReferenceQualifier getReferenceQualifier() {
                return (TelReferenceQualifier)TelReferenceExpression.this.findChildByClass(TelReferenceQualifier.class);
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                String newPropertyName;
                PsiElement resolve = this.resolve();
                if (resolve instanceof PsiMethod && PropertyUtil.getPropertyName((PsiMethod)((PsiMethod)resolve)) != null && (newPropertyName = PropertyUtil.getPropertyName((String)newElementName)) != null) {
                    newElementName = newPropertyName;
                }
                PsiElement newReferenceName = TelPsiUtil.parseReference(newElementName, TelReferenceExpression.this.getProject()).getReferenceNameElement();
                TelReferenceExpression.this.getNode().replaceChild(TelReferenceExpression.this.getReferenceNameElement().getNode(), newReferenceName.getNode());
                return TelReferenceExpression.this;
            }
        };
    }

    private PsiElement getReferenceNameElement() {
        return this.findChildByType(TelTokenTypes.TAP5_EL_IDENTIFIER);
    }

    @NotNull
    public TelQualifiedReference getReference() {
        TelQualifiedReference telQualifiedReference = this.myReference;
        if (telQualifiedReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelReferenceExpression", "getReference"));
        }
        return telQualifiedReference;
    }

    @Override
    @Nullable
    public PsiType getPsiType() {
        return this.myReference.getPsiType();
    }
}

