/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.tapestry.lang.TelFileType;
import com.intellij.tapestry.psi.TelCompositeElementType;
import com.intellij.tapestry.psi.TelLexer;
import com.intellij.tapestry.psi.TelParser;
import com.intellij.tapestry.psi.TelTokenTypes;
import com.intellij.tapestry.psi.impl.TelExpressionHolder;
import org.jetbrains.annotations.NotNull;

public class TelParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        TelLexer telLexer = new TelLexer();
        if (telLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelParserDefinition", "createLexer"));
        }
        return telLexer;
    }

    public IFileElementType getFileNodeType() {
        return TelTokenTypes.TEL_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TelTokenTypes.WHITESPACES;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TelTokenTypes.STRING_LITERALS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        TelParser telParser = new TelParser();
        if (telParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelParserDefinition", "createParser"));
        }
        return telParser;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PsiFileBase(viewProvider, TelFileType.INSTANCE.getLanguage()){
            {
                this.init((IElementType)TelTokenTypes.TEL_FILE, (IElementType)TelTokenTypes.TAP5_EL_HOLDER);
            }

            @NotNull
            public FileType getFileType() {
                TelFileType telFileType = TelFileType.INSTANCE;
                if (telFileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelParserDefinition$1", "getFileType"));
                }
                return telFileType;
            }
        };
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        Lexer lexer = this.createLexer(left.getPsi().getProject());
        return LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)lexer);
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType elementType = node.getElementType();
        if (elementType instanceof TelCompositeElementType) {
            PsiElement psiElement = ((TelCompositeElementType)elementType).createPsiElement(node);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelParserDefinition", "createElement"));
            }
            return psiElement;
        }
        if (elementType == TelTokenTypes.TAP5_EL_HOLDER) {
            TelExpressionHolder telExpressionHolder = new TelExpressionHolder(node);
            if (telExpressionHolder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelParserDefinition", "createElement"));
            }
            return telExpressionHolder;
        }
        throw new AssertionError((Object)("Unknown type: " + elementType));
    }
}

