/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.lang;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.tapestry.lang.TmlFileType;
import com.intellij.tapestry.psi.TelTokenTypes;
import org.jetbrains.annotations.NotNull;

public class TmlTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/tapestry/lang/TmlTypedHandler", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/tapestry/lang/TmlTypedHandler", "charTyped"));
        }
        if (file.getFileType() != TmlFileType.INSTANCE || c != '{') {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAt = file.findElementAt(offset - 1);
        if (elementAt != null) {
            CharSequence charSequence;
            PsiElement parent = elementAt.getParent();
            int index = offset - 2;
            if (index >= 0 && (charSequence = editor.getDocument().getCharsSequence()).length() > index && charSequence.charAt(index) == '$' && parent != null && parent.getNode().getElementType() != TelTokenTypes.TAP5_EL_HOLDER) {
                editor.getDocument().insertString(offset, (CharSequence)"}");
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }
}

