/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.view;

import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.tapestry.core.model.externalizable.ExternalizableToClass;
import com.intellij.tapestry.core.model.externalizable.ExternalizableToTemplate;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.tapestry.intellij.view.TapestryProjectViewPane;
import com.intellij.tapestry.intellij.view.nodes.TapestryNode;
import com.intellij.tapestry.lang.TmlFileType;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;

public class ViewTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -6485912040308583746L;
    private static final Logger _logger = Logger.getInstance(ViewTransferHandler.class);
    private final transient TapestryProjectViewPane _tapestryProjectViewPane;

    public ViewTransferHandler(TapestryProjectViewPane tapestryProjectViewPane) {
        this._tapestryProjectViewPane = tapestryProjectViewPane;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new TapestryElementTransferable(((TapestryNode)((Object)((DefaultMutableTreeNode)this._tapestryProjectViewPane.getTree().getSelectionPath().getLastPathComponent()).getUserObject())).getElement());
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    private class TapestryElementTransferable
    implements Transferable {
        private final Object _data;

        TapestryElementTransferable(Object object) {
            this._data = object;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            PsiFile fileInEditor = PsiManager.getInstance((Project)ViewTransferHandler.this._tapestryProjectViewPane.getProject()).findFile(FileDocumentManager.getInstance().getFile(FileEditorManager.getInstance((Project)ViewTransferHandler.this._tapestryProjectViewPane.getProject()).getSelectedTextEditor().getDocument()));
            FileType typeFileInEditor = fileInEditor.getFileType();
            if (fileInEditor instanceof PsiClassOwner && this._data instanceof ExternalizableToClass) {
                IntellijJavaClassType dropClass = new IntellijJavaClassType((Module)ViewTransferHandler.this._tapestryProjectViewPane.getData(DataKeys.MODULE.getName()), IdeaUtils.findPublicClass(fileInEditor).getContainingFile());
                try {
                    return ((ExternalizableToClass)this._data).getClassRepresentation(dropClass);
                }
                catch (Exception ex) {
                    _logger.error((Throwable)ex);
                    throw new UnsupportedFlavorException(flavor);
                }
            }
            if (typeFileInEditor.equals((Object)TmlFileType.INSTANCE) && this._data instanceof ExternalizableToTemplate) {
                try {
                    return ((ExternalizableToTemplate)this._data).getTemplateRepresentation(TapestryUtils.getTapestryNamespacePrefix((XmlFile)fileInEditor));
                }
                catch (Exception ex) {
                    _logger.error((Throwable)ex);
                    throw new UnsupportedFlavorException(flavor);
                }
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.stringFlavor.equals(flavor);
        }
    }
}

