/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.view;

import com.intellij.ProjectTopics;
import com.intellij.ide.DataManager;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.events.FileSystemListener;
import com.intellij.tapestry.core.events.TapestryModelChangeListener;
import com.intellij.tapestry.core.exceptions.NotTapestryElementException;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.actions.safedelete.SafeDeleteProvider;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.core.resource.IntellijResource;
import com.intellij.tapestry.intellij.toolwindow.TapestryToolWindow;
import com.intellij.tapestry.intellij.toolwindow.TapestryToolWindowFactory;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.tapestry.intellij.view.TapestryIdeView;
import com.intellij.tapestry.intellij.view.TapestryProjectSelectInTarget;
import com.intellij.tapestry.intellij.view.TapestryViewTreeBuilder;
import com.intellij.tapestry.intellij.view.ViewMouseListener;
import com.intellij.tapestry.intellij.view.ViewTransferHandler;
import com.intellij.tapestry.intellij.view.actions.GroupElementFilesToggleAction;
import com.intellij.tapestry.intellij.view.actions.ShowLibrariesTogleAction;
import com.intellij.tapestry.intellij.view.actions.StartInBasePackageAction;
import com.intellij.tapestry.intellij.view.nodes.ClassNode;
import com.intellij.tapestry.intellij.view.nodes.ComponentNode;
import com.intellij.tapestry.intellij.view.nodes.ExternalLibraryNode;
import com.intellij.tapestry.intellij.view.nodes.FileNode;
import com.intellij.tapestry.intellij.view.nodes.MixinNode;
import com.intellij.tapestry.intellij.view.nodes.ModuleNode;
import com.intellij.tapestry.intellij.view.nodes.PageNode;
import com.intellij.tapestry.intellij.view.nodes.TapestryNode;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import icons.TapestryIcons;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class TapestryProjectViewPane
extends AbstractProjectViewPane
implements FileSystemListener,
TapestryModelChangeListener {
    private static final String VIEW_TITLE = "Tapestry";
    private static final String ID = "TapestryProjectView";
    private static final String COMPONENT_NAME = "TAPESTRY_PROJECT_VIEW";
    private final ModuleListener myModuleListener;
    private final TapestryIdeView myIdeView = new TapestryIdeView(this);
    private JScrollPane myComponent;
    private boolean myShown;
    private boolean myGroupElementFiles = true;
    private boolean myShowLibraries = true;
    private boolean myFromBasePackage;
    private final MessageBusConnection myMessageBusConnection;

    public TapestryProjectViewPane(Project project) {
        super(project);
        this.myModuleListener = new ModuleAdapter(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tapestry/intellij/view/TapestryProjectViewPane$1", "moduleRemoved"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/tapestry/intellij/view/TapestryProjectViewPane$1", "moduleRemoved"));
                }
                TapestryProjectViewPane.this.reload();
            }

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tapestry/intellij/view/TapestryProjectViewPane$1", "moduleAdded"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/tapestry/intellij/view/TapestryProjectViewPane$1", "moduleAdded"));
                }
                TapestryProjectViewPane.this.reload();
            }
        };
        this.myMessageBusConnection = project.getMessageBus().connect();
        this.myMessageBusConnection.subscribe(ProjectTopics.MODULES, (Object)this.myModuleListener);
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            TapestryModuleSupportLoader.getTapestryProject(module).getEventsManager().addFileSystemListener(this);
            TapestryModuleSupportLoader.getTapestryProject(module).getEventsManager().addTapestryModelListener(this);
        }
    }

    public boolean isInitiallyVisible() {
        this.myShown = false;
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (!TapestryUtils.isTapestryModule(module)) continue;
            this.myShown = true;
            break;
        }
        return this.myShown;
    }

    public void addToolbarActions(DefaultActionGroup defaultactiongroup) {
        for (AnAction action : defaultactiongroup.getChildren(null)) {
            if (action.getTemplatePresentation().getText().equals("Autoscroll to Source")) continue;
            defaultactiongroup.remove(action);
        }
        defaultactiongroup.addAction((AnAction)new StartInBasePackageAction(){

            public boolean isSelected(AnActionEvent e) {
                return TapestryProjectViewPane.this.myFromBasePackage;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                TapestryProjectViewPane.this.myFromBasePackage = state;
                TapestryProjectViewPane.this.updateFromRoot(false);
            }
        }).setAsSecondary(true);
        defaultactiongroup.addAction((AnAction)new GroupElementFilesToggleAction(){

            public boolean isSelected(AnActionEvent e) {
                return TapestryProjectViewPane.this.myGroupElementFiles;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                TapestryProjectViewPane.this.myGroupElementFiles = state;
                TapestryProjectViewPane.this.updateFromRoot(false);
            }
        }).setAsSecondary(true);
        defaultactiongroup.addAction((AnAction)new ShowLibrariesTogleAction(){

            public boolean isSelected(AnActionEvent e) {
                return TapestryProjectViewPane.this.myShowLibraries;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                TapestryProjectViewPane.this.myShowLibraries = state;
                TapestryProjectViewPane.this.updateFromRoot(false);
            }
        }).setAsSecondary(true);
        defaultactiongroup.add((AnAction)new CollapseAllAction((JTree)this.myTree));
    }

    public static TapestryProjectViewPane getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tapestry/intellij/view/TapestryProjectViewPane", "getInstance"));
        }
        return (TapestryProjectViewPane)ProjectView.getInstance((Project)project).getProjectViewPaneById(ID);
    }

    public void reload() {
        this.modulesChanged();
        this.updateFromRoot(true);
    }

    public String getTitle() {
        return VIEW_TITLE;
    }

    public Icon getIcon() {
        return TapestryIcons.Tapestry_logo_small;
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/view/TapestryProjectViewPane", "getId"));
        }
        return ID;
    }

    public JComponent createComponent() {
        this.initTree();
        return this.myComponent;
    }

    @NotNull
    public ActionCallback updateFromRoot(boolean b) {
        if (this.myTree != null) {
            ((SimpleTreeBuilder)this.getTreeBuilder()).updateFromRoot(b);
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/view/TapestryProjectViewPane", "updateFromRoot"));
        }
        return actionCallback;
    }

    public void select(Object object, VirtualFile virtualFile, boolean b) {
    }

    public int getWeight() {
        return 5;
    }

    public SelectInTarget createSelectInTarget() {
        return new TapestryProjectSelectInTarget(this.myProject);
    }

    @Override
    public void fileCreated(String path) {
        this.updateFromRoot(true);
    }

    @Override
    public void fileDeleted(String path) {
        this.updateFromRoot(true);
    }

    @Override
    public void classCreated(String classFqn) {
        this.updateFromRoot(true);
    }

    @Override
    public void classDeleted(String classFqn) {
        this.updateFromRoot(true);
    }

    @Override
    public void fileContentsChanged(IResource changedFile) {
    }

    @Override
    public void modelChanged() {
        this.reload();
    }

    public void dispose() {
        if (this.myModuleListener != null) {
            this.myMessageBusConnection.disconnect();
        }
        super.dispose();
    }

    public boolean canSelect() {
        return !this.getPathToSelect().isEmpty();
    }

    public boolean isGroupElementFiles() {
        return this.myGroupElementFiles;
    }

    public boolean isShowLibraries() {
        return this.myShowLibraries;
    }

    public boolean isFromBasePackage() {
        return this.myFromBasePackage;
    }

    private List<Object> getPathToSelect() {
        return Collections.emptyList();
    }

    public Object getData(String dataId) {
        NodeDescriptor nodeDescriptor;
        if (DataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (DataKeys.IDE_VIEW.is(dataId)) {
            if (this.getSelectedDescriptor() == null) {
                return null;
            }
            Object element = this.getSelectedDescriptor().getElement();
            if (!(element instanceof PsiDirectory) && !(element instanceof PsiFile) || IdeaUtils.findFirstParent(this.getSelectedNode(), ExternalLibraryNode.class) != null) {
                return null;
            }
            return this.myIdeView;
        }
        if (DataKeys.MODULE.is(dataId) && (nodeDescriptor = this.getSelectedDescriptor()) != null) {
            if (nodeDescriptor instanceof TapestryNode) {
                return ((TapestryNode)nodeDescriptor).getModule();
            }
            if (nodeDescriptor instanceof ModuleNode) {
                return ((ModuleNode)nodeDescriptor).getModule();
            }
        }
        if (DataKeys.NAVIGATABLE.is(dataId)) {
            if (this.getSelectedDescriptor() == null) {
                return null;
            }
            if (this.getSelectedDescriptor().getElement() instanceof PresentationLibraryElement) {
                return ((IntellijResource)((PresentationLibraryElement)this.getSelectedDescriptor().getElement()).getElementClass().getFile()).getPsiFile();
            }
        }
        if (DataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return new SafeDeleteProvider();
        }
        return null;
    }

    Project getProject() {
        return this.myProject;
    }

    private void initTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("root");
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.myTree = new ProjectViewTree(this.myProject, treeModel){

            public String toString() {
                return TapestryProjectViewPane.this.getTitle() + " " + super.toString();
            }

            public DefaultMutableTreeNode getSelectedNode() {
                return TapestryProjectViewPane.this.getSelectedNode();
            }
        };
        this.setTreeBuilder((AbstractTreeBuilder)new TapestryViewTreeBuilder((JTree)this.myTree, this.myProject));
        ((SimpleTreeBuilder)this.getTreeBuilder()).initRoot();
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.myTree.expandPath(new TreePath(this.myTree.getModel().getRoot()));
        TreeUtil.expandRootChildIfOnlyOne((JTree)this.myTree);
        this.myTree.getSelectionModel().setSelectionMode(4);
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.setTransferHandler((TransferHandler)new ViewTransferHandler(this));
        ViewMouseListener mouseListener = new ViewMouseListener(this);
        this.myTree.addMouseListener((MouseListener)mouseListener);
        this.myTree.addMouseMotionListener((MouseMotionListener)mouseListener);
        this.addTreeListeners();
        new TreeSpeedSearch((JTree)this.myTree);
        this.myTreeStructure = this.getTreeBuilder().getTreeStructure();
        this.myComponent = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        this.myComponent.setBorder(BorderFactory.createEmptyBorder());
        this.installTreePopupHandler("ProjectViewPopup", "ProjectViewPopupMenu");
    }

    protected void installTreePopupHandler(final String place, final String groupName) {
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(groupName);
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu(place, group);
                popupMenu.getComponent().show(comp, x, y);
            }
        };
        this.myTree.addMouseListener((MouseListener)popupHandler);
    }

    private void addTreeListeners() {
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                TapestryToolWindow toolWindow;
                TapestryProjectViewPane.this.fireTreeChangeListener();
                if (event.getNewLeadSelectionPath() != null && (toolWindow = TapestryToolWindowFactory.getToolWindow(TapestryProjectViewPane.this.getProject())) != null) {
                    SimpleNode selectedNode = (SimpleNode)((DefaultMutableTreeNode)event.getNewLeadSelectionPath().getLastPathComponent()).getUserObject();
                    if (!(selectedNode instanceof TapestryNode)) {
                        toolWindow.update(null, null, null);
                        return;
                    }
                    if (selectedNode instanceof PageNode || selectedNode instanceof ComponentNode || selectedNode instanceof MixinNode) {
                        toolWindow.update((Module)TapestryProjectViewPane.this.getData(DataKeys.MODULE.getName()), selectedNode.getElement(), Arrays.asList(((PresentationLibraryElement)selectedNode.getElement()).getElementClass()));
                    }
                    if (selectedNode instanceof ClassNode || selectedNode instanceof FileNode) {
                        TapestryNode parentSelectedNode = (TapestryNode)((Object)((DefaultMutableTreeNode)((DefaultMutableTreeNode)event.getNewLeadSelectionPath().getLastPathComponent()).getParent()).getUserObject());
                        if (parentSelectedNode.getElement() instanceof PresentationLibraryElement) {
                            toolWindow.update((Module)TapestryProjectViewPane.this.getData(DataKeys.MODULE.getName()), parentSelectedNode.getElement(), Arrays.asList(((PresentationLibraryElement)parentSelectedNode.getElement()).getElementClass()));
                        } else {
                            IJavaClassType elementClass = null;
                            PresentationLibraryElement component = null;
                            Module module = ((TapestryNode)selectedNode).getModule();
                            TapestryProject tapestryProject = TapestryModuleSupportLoader.getTapestryProject(module);
                            if (selectedNode instanceof ClassNode) {
                                elementClass = new IntellijJavaClassType(module, (PsiFile)selectedNode.getElement());
                                try {
                                    component = PresentationLibraryElement.createProjectElementInstance(elementClass, tapestryProject);
                                }
                                catch (NotTapestryElementException notTapestryElementException) {
                                    // empty catch block
                                }
                            }
                            if (selectedNode instanceof FileNode && (elementClass = tapestryProject.findElementByTemplate((PsiFile)selectedNode.getElement()).getElementClass()) != null) {
                                component = PresentationLibraryElement.createProjectElementInstance(elementClass, tapestryProject);
                            }
                            if (component != null) {
                                toolWindow.update((Module)TapestryProjectViewPane.this.getData(DataKeys.MODULE.getName()), component, Arrays.asList(component.getElementClass()));
                            }
                        }
                    }
                    if (!(selectedNode instanceof PageNode || selectedNode instanceof ComponentNode || selectedNode instanceof MixinNode || selectedNode instanceof ClassNode || selectedNode instanceof FileNode)) {
                        toolWindow.update(null, null, null);
                    }
                }
            }
        });
        this.myTree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                TapestryProjectViewPane.this.fireTreeChangeListener();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                TapestryProjectViewPane.this.fireTreeChangeListener();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                TapestryProjectViewPane.this.fireTreeChangeListener();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                TapestryProjectViewPane.this.fireTreeChangeListener();
            }
        });
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)TapestryProjectViewPane.this.myTree);
                    OpenSourceUtil.openSourcesFrom((DataContext)dataContext, (boolean)false);
                } else if (27 == e.getKeyCode()) {
                    boolean[] isCopied;
                    if (e.isConsumed()) {
                        return;
                    }
                    PsiCopyPasteManager copyPasteManager = PsiCopyPasteManager.getInstance();
                    if (copyPasteManager.getElements(isCopied = new boolean[1]) != null && !isCopied[0]) {
                        copyPasteManager.clear();
                        e.consume();
                    }
                }
            }
        });
    }

    private void modulesChanged() {
        boolean shouldShow = false;
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            TapestryModuleSupportLoader.getTapestryProject(module).getEventsManager().removeFileSystemListener(this);
            TapestryModuleSupportLoader.getTapestryProject(module).getEventsManager().removeTapestryModelListener(this);
            TapestryModuleSupportLoader.getTapestryProject(module).getEventsManager().addFileSystemListener(this);
            TapestryModuleSupportLoader.getTapestryProject(module).getEventsManager().addTapestryModelListener(this);
            if (!TapestryUtils.isTapestryModule(module)) continue;
            shouldShow = true;
        }
        if (shouldShow && !this.myShown) {
            this.addMe();
        }
        if (!shouldShow && this.myShown) {
            this.removeMe();
        }
    }

    private void addMe() {
        ProjectView projectView = ProjectView.getInstance((Project)this.myProject);
        projectView.addProjectPane((AbstractProjectViewPane)this);
        this.myShown = true;
    }

    private void removeMe() {
        ProjectView projectView = ProjectView.getInstance((Project)this.myProject);
        projectView.removeProjectPane((AbstractProjectViewPane)this);
        this.myShown = false;
    }
}

