/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.toolwindow;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.tapestry.intellij.toolwindow.TapestryToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestryToolWindowFactory
implements ToolWindowFactory {
    public static final String TAPESTRY_TOOLWINDOW_ID = "Tapestry";
    private static final Key<TapestryToolWindow> TAPESTRY_TOOL_WINDOW_KEY = Key.create((String)"tapestry.toolWindow");

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tapestry/intellij/toolwindow/TapestryToolWindowFactory", "createToolWindowContent"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/tapestry/intellij/toolwindow/TapestryToolWindowFactory", "createToolWindowContent"));
        }
        toolWindow.setAvailable(true, null);
        TapestryToolWindow tapestryToolWindow = new TapestryToolWindow(project);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)tapestryToolWindow.getMainPanel(), TAPESTRY_TOOLWINDOW_ID, true);
        toolWindow.getContentManager().addContent(content);
        project.putUserData(TAPESTRY_TOOL_WINDOW_KEY, (Object)tapestryToolWindow);
    }

    @Nullable
    public static TapestryToolWindow getToolWindow(Project project) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(TAPESTRY_TOOLWINDOW_ID);
        return toolWindow == null ? null : (TapestryToolWindow)project.getUserData(TAPESTRY_TOOL_WINDOW_KEY);
    }
}

