/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang.descriptor;

import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.tapestry.intellij.lang.descriptor.DescriptorUtil;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryNamespaceDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import org.jetbrains.annotations.Nullable;

public abstract class BasicTapestryTagDescriptor
implements XmlElementDescriptor,
PsiWritableMetaData {
    private final TapestryNamespaceDescriptor myNamespaceDescriptor;
    private final String myNamespacePrefix;

    public BasicTapestryTagDescriptor(@Nullable String namespacePrefix, TapestryNamespaceDescriptor descriptor) {
        this.myNamespacePrefix = namespacePrefix;
        this.myNamespaceDescriptor = descriptor;
    }

    protected final String getPrefixWithColon() {
        return this.myNamespacePrefix != null && this.myNamespacePrefix.length() > 0 ? this.myNamespacePrefix + ":" : "";
    }

    public String getQualifiedName() {
        return this.getDefaultName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        return DescriptorUtil.getTmlSubelementDescriptors(context, this.myNamespaceDescriptor);
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        return DescriptorUtil.getTmlOrHtmlTagDescriptor(childTag);
    }

    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        String prefix = attribute.getNamespacePrefix();
        return prefix.length() == 0 || prefix.equals(this.myNamespacePrefix) ? this.getAttributeDescriptor(attribute.getName(), attribute.getParent()) : null;
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myNamespaceDescriptor;
    }

    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return 1;
    }

    public String getDefaultValue() {
        return null;
    }

    @Nullable
    public PsiElement getDeclaration() {
        return null;
    }

    public String getName(PsiElement context) {
        return this.getDefaultName();
    }

    public String getName() {
        return this.getDefaultName();
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void setName(String name) throws IncorrectOperationException {
    }
}

