/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.java.IJavaType;
import com.intellij.tapestry.core.java.coercion.TypeCoercionValidator;
import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.model.presentation.TapestryParameter;
import com.intellij.tapestry.core.model.presentation.valueresolvers.AbstractValueResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ResolvedValue;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ValueResolverChain;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.lang.TemplateColorSettingsPage;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import org.jetbrains.annotations.NotNull;

public class TemplateTagAnnotator
extends XmlRecursiveElementVisitor
implements Annotator {
    private static final Logger _logger = Logger.getInstance(TemplateTagAnnotator.class);
    private AnnotationHolder annotationHolder = null;

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder annotationHolder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/tapestry/intellij/lang/annotator/TemplateTagAnnotator", "annotate"));
        }
        if (annotationHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationHolder", "com/intellij/tapestry/intellij/lang/annotator/TemplateTagAnnotator", "annotate"));
        }
        this.annotationHolder = annotationHolder;
        try {
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.annotationHolder = null;
        }
    }

    public void visitXmlTag(XmlTag tag) {
        if (TapestryUtils.getComponentIdentifier(tag) != null) {
            Component component;
            this.annotateTapestryTag(tag);
            XmlAttribute attr = TapestryUtils.getIdentifyingAttribute(tag);
            if (attr != null) {
                this.annotateTapestryAttribute(attr);
            }
            if ((component = TapestryUtils.getTypeOfTag(tag)) != null) {
                TapestryProject tapestryProject = TapestryModuleSupportLoader.getTapestryProject((XmlElement)tag);
                PresentationLibraryElement element = tapestryProject == null ? null : tapestryProject.findElementByTemplate(tag.getContainingFile());
                IntellijJavaClassType elementClass = element != null ? (IntellijJavaClassType)element.getElementClass() : null;
                for (TapestryParameter parameter : component.getParameters().values()) {
                    String paramName = parameter.getName();
                    XmlAttribute attribute = TapestryUtils.getTapestryAttribute(tag, paramName);
                    if (attribute == null) continue;
                    this.annotateTapestryAttribute(attribute);
                    if (elementClass == null) continue;
                    this.annotateAttributeValue(tapestryProject, elementClass, parameter, attribute);
                }
            }
        }
        tag.acceptChildren((PsiElementVisitor)this);
    }

    private void annotateAttributeValue(TapestryProject tapestryProject, IntellijJavaClassType elementClass, TapestryParameter parameter, XmlAttribute attribute) {
        ResolvedValue resolvedValue;
        XmlAttributeValue value = attribute.getValueElement();
        if (value == null) {
            return;
        }
        try {
            resolvedValue = ValueResolverChain.getInstance().resolve(tapestryProject, elementClass, attribute.getValue(), parameter.getDefaultPrefix());
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception ex) {
            _logger.error((Throwable)ex);
            return;
        }
        if (resolvedValue == null) {
            return;
        }
        IJavaType parameterType = parameter.getParameterField().getType();
        AnnotationHolder holder = this.annotationHolder;
        if (holder != null && !TypeCoercionValidator.canCoerce(tapestryProject, resolvedValue.getType(), AbstractValueResolver.getCleanValue(attribute.getValue()), parameterType)) {
            holder.createErrorAnnotation((PsiElement)value, "Can't coerce a " + resolvedValue.getType().getName() + " to a " + (parameterType != null ? parameterType.getName() : "undefined"));
        }
    }

    private void annotateTapestryTag(XmlTag tag) {
        AnnotationHolder holder = this.annotationHolder;
        if (holder == null) {
            return;
        }
        holder.createInfoAnnotation((PsiElement)IdeaUtils.getNameElement(tag), null).setTextAttributes(TemplateColorSettingsPage.TAG_NAME);
        if (!tag.isEmpty()) {
            holder.createInfoAnnotation((PsiElement)IdeaUtils.getNameElementClosing(tag), null).setTextAttributes(TemplateColorSettingsPage.TAG_NAME);
        }
    }

    private void annotateTapestryAttribute(XmlAttribute attribute) {
        AnnotationHolder holder = this.annotationHolder;
        if (holder != null) {
            holder.createInfoAnnotation(attribute.getFirstChild(), null).setTextAttributes(TemplateColorSettingsPage.ATTR_NAME);
        }
    }
}

