/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryAttributeDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryXmlExtension;
import com.intellij.tapestry.lang.TelLanguage;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TelLanguageInjector
implements MultiHostInjector {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/tapestry/intellij/lang/TelLanguageInjector", "getLanguagesToInject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/tapestry/intellij/lang/TelLanguageInjector", "getLanguagesToInject"));
        }
        PsiElement contextParent = context.getParent();
        if (!(contextParent instanceof XmlAttribute)) {
            return;
        }
        XmlAttribute attr = (XmlAttribute)contextParent;
        String name = attr.getLocalName();
        if ("type".equals(name) || "id".equals(name)) {
            return;
        }
        XmlTag parent = attr.getParent();
        if (parent == null) {
            return;
        }
        if (!TapestryXmlExtension.isTapestryTemplateNamespace(attr.getNamespace()) && !TapestryXmlExtension.isTapestryTemplateNamespace(parent.getNamespace())) {
            return;
        }
        if (attr.textContains('\n')) {
            return;
        }
        String value = attr.getValue();
        if (value.indexOf(36) != -1 || value.indexOf(123) != -1 || value.indexOf(125) != -1 || value.indexOf(47) != -1 || value.indexOf(92) != -1) {
            return;
        }
        String propPrefix = "prop:";
        boolean explicitProp = value.startsWith("prop:");
        TextRange range = attr.getValueTextRange();
        if (!explicitProp) {
            XmlAttributeDescriptor descriptor = attr.getDescriptor();
            if (!(descriptor instanceof TapestryAttributeDescriptor)) return;
            TapestryAttributeDescriptor tapestryAttributeDescriptor = (TapestryAttributeDescriptor)descriptor;
            String prefix = tapestryAttributeDescriptor.getDefaultPrefix();
            if (prefix != null && !"prop".equals(prefix)) {
                return;
            }
        } else if (range.getLength() >= "prop:".length()) {
            range = new TextRange(range.getStartOffset() + "prop:".length(), range.getEndOffset());
        }
        registrar.startInjecting((Language)TelLanguage.INSTANCE).addPlace("${", "}", (PsiLanguageInjectionHost)context, range).doneInjecting();
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlAttributeValue.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/TelLanguageInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

