/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.facet;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.tapestry.core.maven.MavenConfiguration;
import com.intellij.tapestry.core.maven.MavenUtils;
import com.intellij.tapestry.core.maven.RemoteRepositoryDescription;
import com.intellij.tapestry.core.util.StringUtils;
import com.intellij.tapestry.intellij.facet.TapestryFacetConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class AddTapestrySupportUtil {
    private static final Logger _logger = Logger.getInstance(AddTapestrySupportUtil.class);

    public static void addSupportInWriteCommandAction(final @NotNull Module module, final @NotNull TapestryFacetConfiguration configuration, final boolean generateStartupApplication, final boolean generatePom) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/tapestry/intellij/facet/AddTapestrySupportUtil", "addSupportInWriteCommandAction"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/tapestry/intellij/facet/AddTapestrySupportUtil", "addSupportInWriteCommandAction"));
        }
        if (configuration.getApplicationPackage() == null) {
            return;
        }
        new WriteCommandAction.Simple(module.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                try {
                    AddTapestrySupportUtil.addSupport(module, configuration, generateStartupApplication, generatePom);
                }
                catch (Exception ex) {
                    _logger.error((Throwable)ex);
                }
            }
        }.execute();
    }

    private static void addSupport(Module module, TapestryFacetConfiguration configuration, boolean generateStartupApplication, boolean generatePom) throws Exception {
        if (generatePom) {
            AddTapestrySupportUtil.generatePom(module, configuration);
        }
    }

    private static void generatePom(Module module, TapestryFacetConfiguration configuration) throws IOException {
        ModuleRootManager rootModel = ModuleRootManager.getInstance((Module)module);
        VirtualFile[] contentRoots = rootModel.getContentRoots();
        if (contentRoots.length == 0) {
            _logger.warn("Couldn't generate pom because it wasn't possible to determine the module content root.");
            return;
        }
        if (rootModel.getSourceRoots().length == 0) {
            _logger.warn("Coulnd't generate startup application because it wasn't possible to determine module source root");
            return;
        }
        String modulePath = contentRoots[0].getPath();
        try {
            String pomText = StringUtils.toString(AddTapestrySupportUtil.class.getResourceAsStream("/fileTemplates/j2ee/Tapestry Project Pom.xml.ft"));
            pomText = pomText.replace("${GROUP}", configuration.getApplicationPackage());
            pomText = pomText.replace("${ARTIFACT}", configuration.getFilterName());
            pomText = pomText.replace("${NAME}", rootModel.getModule().getName());
            pomText = pomText.replace("${SOURCE_PATH}", rootModel.getSourceRoots()[0].getPath().substring(modulePath.length() + 1));
            pomText = pomText.replace("${TAPESTRY_VERSION}", configuration.getVersion().toString());
            VirtualFileManager.getInstance().findFileByUrl("file://" + modulePath);
            PsiDirectory psiDirectory = PsiManager.getInstance((Project)rootModel.getModule().getProject()).findDirectory(VirtualFileManager.getInstance().findFileByUrl("file://" + modulePath));
            String pomXml = "pom.xml";
            PsiFile pomFile = psiDirectory.findFile("pom.xml");
            if (pomFile == null) {
                pomFile = psiDirectory.createFile("pom.xml");
            }
            VfsUtil.saveText((VirtualFile)pomFile.getVirtualFile(), (String)pomText);
        }
        catch (Exception ex) {
            _logger.error((Throwable)ex);
        }
        MavenUtils.createMavenSupport(modulePath, new MavenConfiguration(false, false, null, null, null, configuration.getApplicationPackage(), configuration.getFilterName(), "1.0-SNAPSHOT", new ArrayList<RemoteRepositoryDescription>()), configuration.getVersion().toString());
    }
}

