/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.core.java;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.rename.RegExpValidator;
import com.intellij.tapestry.core.java.IJavaAnnotation;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.java.IJavaMethod;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.intellij.core.java.IntellijJavaAnnotation;
import com.intellij.tapestry.intellij.core.java.IntellijJavaField;
import com.intellij.tapestry.intellij.core.java.IntellijJavaMethod;
import com.intellij.tapestry.intellij.core.java.IntellijJavaType;
import com.intellij.tapestry.intellij.core.resource.IntellijResource;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijJavaClassType
extends IntellijJavaType
implements IJavaClassType {
    @NotNull
    private final String _classFilePath;
    private PsiClassType _psiClassType;
    private Module _module;
    private Boolean _supportInformalParameters;
    private static Collection<String> annotations = Arrays.asList("org.apache.tapestry5.annotations.SupportsInformalParameters");

    public IntellijJavaClassType(Module module, PsiFile psiFile) {
        this._module = module;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = psiFile.getViewProvider().getVirtualFile();
        }
        this._classFilePath = virtualFile.getUrl();
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getPsiClass().getQualifiedName();
    }

    @Override
    public String getName() {
        return this.getPsiClass().getName();
    }

    @Override
    public boolean isInterface() {
        return this.getPsiClass().isInterface();
    }

    @Override
    public boolean isPublic() {
        return this.getPsiClass().getModifierList().hasModifierProperty("public");
    }

    @Override
    public boolean isEnum() {
        return this.getPsiClass().isEnum();
    }

    @Override
    @Nullable
    public IntellijJavaClassType getSuperClassType() {
        PsiClass superClass = this.getPsiClass().getSuperClass();
        return superClass != null ? new IntellijJavaClassType(this._module, superClass.getContainingFile()) : null;
    }

    @Override
    public boolean hasDefaultConstructor() {
        return PsiUtil.hasDefaultConstructor((PsiClass)this.getPsiClass());
    }

    @Override
    public Collection<IJavaMethod> getPublicMethods(boolean fromSuper) {
        ArrayList<IJavaMethod> foundMethods = new ArrayList<IJavaMethod>();
        for (PsiMethod method : this.getMethods(fromSuper)) {
            if (!method.getModifierList().hasExplicitModifier("public") || !this.isNotMethodOfJavaLangObject(method)) continue;
            foundMethods.add(new IntellijJavaMethod(this._module, method));
        }
        return foundMethods;
    }

    private boolean isNotMethodOfJavaLangObject(PsiMethod method) {
        return !method.getContainingClass().getQualifiedName().equals("java.lang.Object");
    }

    private PsiMethod[] getMethods(boolean fromSuper) {
        return fromSuper ? this.getPsiClass().getAllMethods() : this.getPsiClass().getMethods();
    }

    @Override
    public Collection<IJavaMethod> getAllMethods(boolean fromSuper) {
        ArrayList<IJavaMethod> foundMethods = new ArrayList<IJavaMethod>();
        for (PsiMethod method : this.getMethods(fromSuper)) {
            if (!this.isNotMethodOfJavaLangObject(method)) continue;
            foundMethods.add(new IntellijJavaMethod(this._module, method));
        }
        return foundMethods;
    }

    @Override
    public Collection<IJavaMethod> findPublicMethods(String methodNameRegExp) {
        RegExpValidator regexpValidator = new RegExpValidator(methodNameRegExp);
        ArrayList<IJavaMethod> foundMethods = new ArrayList<IJavaMethod>();
        Collection<IJavaMethod> allMethods = this.getPublicMethods(true);
        for (IJavaMethod method : allMethods) {
            if (!regexpValidator.value(method.getName())) continue;
            foundMethods.add(method);
        }
        return foundMethods;
    }

    @Override
    public Collection<IJavaAnnotation> getAnnotations() {
        ArrayList<IJavaAnnotation> annotations = new ArrayList<IJavaAnnotation>();
        PsiClass psiClass = this.getPsiClass();
        if (psiClass == null) {
            return annotations;
        }
        for (PsiAnnotation annotation : this.getPsiClass().getModifierList().getAnnotations()) {
            annotations.add(new IntellijJavaAnnotation(annotation));
        }
        return annotations;
    }

    @Override
    public Map<String, IJavaField> getFields(boolean fromSuper) {
        PsiField[] classFields;
        HashMap<String, IJavaField> fields = new HashMap<String, IJavaField>();
        PsiClass psiClass = this.getPsiClass();
        if (psiClass == null) {
            return fields;
        }
        try {
            classFields = fromSuper ? this.getPsiClass().getAllFields() : this.getPsiClass().getFields();
        }
        catch (PsiInvalidElementAccessException ex) {
            return fields;
        }
        for (PsiField field : classFields) {
            fields.put(field.getName(), new IntellijJavaField(this._module, field));
        }
        return fields;
    }

    @Override
    public String getDocumentation() {
        StringBuffer description = new StringBuffer();
        PsiClass psiClass = this.getPsiClass();
        if (psiClass == null) {
            return description.toString();
        }
        PsiDocComment document = this.getPsiClass().getDocComment();
        if (document == null) {
            document = ((PsiClass)this.getPsiClass().getNavigationElement()).getDocComment();
        }
        if (document != null) {
            for (PsiElement comment : document.getDescriptionElements()) {
                if (comment instanceof PsiWhiteSpace) continue;
                description.append(comment.getText());
            }
        }
        return description.toString();
    }

    @Override
    public IResource getFile() {
        VirtualFile vf = VirtualFileManager.getInstance().findFileByUrl(this._classFilePath);
        if (vf != null) {
            return new IntellijResource(PsiManager.getInstance((Project)this._module.getProject()).findFile(vf));
        }
        return null;
    }

    @Override
    public boolean supportsInformalParameters() {
        if (this._supportInformalParameters == null) {
            boolean result = false;
            PsiClass psiClass = this.getPsiClass();
            if (psiClass != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, annotations, (boolean)true)) {
                result = true;
            }
            this._supportInformalParameters = result;
        }
        return this._supportInformalParameters;
    }

    @Nullable
    public PsiClass getPsiClass() {
        PsiClass res;
        if (this._psiClassType != null && this._psiClassType.isValid() && this._psiClassType.resolve().getContainingFile().isValid()) {
            res = this._psiClassType.resolve();
        } else {
            this.processPsiClassType();
            res = this._psiClassType != null ? this._psiClassType.resolve() : null;
        }
        return res;
    }

    @Override
    @NotNull
    public Object getUnderlyingObject() {
        if (this._psiClassType == null) {
            this.processPsiClassType();
        }
        PsiClassType psiClassType = this._psiClassType;
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/core/java/IntellijJavaClassType", "getUnderlyingObject"));
        }
        return psiClassType;
    }

    private void processPsiClassType() {
        PsiClass aClass;
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(this._classFilePath);
        if (file == null) {
            this._psiClassType = null;
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this._module.getProject()).findFile(file);
        if (psiFile instanceof PsiClassOwner) {
            PsiClass[] psiClasses = ((PsiClassOwner)psiFile).getClasses();
            aClass = IdeaUtils.findPublicClass(psiClasses);
            if (aClass == null && psiClasses.length > 0) {
                aClass = psiClasses[0];
            }
            if (aClass == null) {
                throw new AssertionError((Object)("no classes found: " + this._classFilePath));
            }
        } else {
            throw new AssertionError((Object)(psiFile + ": " + this._classFilePath));
        }
        this._psiClassType = JavaPsiFacade.getInstance((Project)this._module.getProject()).getElementFactory().createType(aClass);
    }
}

