/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.core.java;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.tapestry.core.java.IJavaAnnotation;
import com.intellij.util.containers.hash.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class IntellijJavaAnnotation
implements IJavaAnnotation {
    private PsiAnnotation _psiAnnotation;
    private static final Key<CachedValue<Map<String, String[]>>> ourParametersMapKey = Key.create((String)"parameters.map");
    private static final UserDataCache<CachedValue<Map<String, String[]>>, PsiAnnotation, Object> ourParametersMapCache = new UserDataCache<CachedValue<Map<String, String[]>>, PsiAnnotation, Object>(){

        protected final CachedValue<Map<String, String[]>> compute(PsiAnnotation owner, Object o) {
            return CachedValuesManager.getManager((Project)owner.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)IntellijJavaAnnotation.doCalcParameters(owner), new Object[]{owner}), false);
        }
    };

    public IntellijJavaAnnotation(PsiAnnotation psiAnnotation) {
        this._psiAnnotation = psiAnnotation;
    }

    @Override
    public String getFullyQualifiedName() {
        return this._psiAnnotation.getQualifiedName();
    }

    @Override
    public Map<String, String[]> getParameters() {
        return (Map)((CachedValue)ourParametersMapCache.get(ourParametersMapKey, (UserDataHolder)this._psiAnnotation, null)).getValue();
    }

    public PsiAnnotation getPsiAnnotation() {
        return this._psiAnnotation;
    }

    private static Map<String, String[]> doCalcParameters(PsiAnnotation owner) {
        HashMap parameters = new HashMap();
        for (PsiNameValuePair parameter : owner.getParameterList().getAttributes()) {
            String literalValue = parameter.getLiteralValue();
            if (literalValue != null) {
                parameters.put(parameter.getName(), new String[]{literalValue});
                continue;
            }
            PsiAnnotationMemberValue value = parameter.getValue();
            String stringValue = IntellijJavaAnnotation.calcValue(value);
            if (stringValue != null) {
                parameters.put(parameter.getName(), new String[]{stringValue});
                continue;
            }
            if (!(value instanceof PsiArrayInitializerMemberValue)) continue;
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)value).getInitializers();
            String[] values = new String[initializers.length];
            for (int i = 0; i < initializers.length; ++i) {
                values[i] = IntellijJavaAnnotation.calcValue(initializers[i]);
            }
            parameters.put(parameter.getName(), values);
        }
        return parameters;
    }

    @Nullable
    private static String calcValue(PsiAnnotationMemberValue value) {
        PsiExpression initializer;
        PsiElement resolve;
        if (value instanceof PsiLiteralExpression && ((PsiLiteralExpression)value).getValue() != null) {
            return ((PsiLiteralExpression)value).getValue().toString();
        }
        if (value instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)value).resolve()) instanceof PsiField && (initializer = ((PsiField)resolve).getInitializer()) instanceof PsiLiteralExpression) {
            return ((PsiLiteralExpression)initializer).getValue().toString();
        }
        return null;
    }
}

