/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.actions.safedelete;

import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.SafeDeleteRefactoring;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.intellij.core.resource.IntellijResource;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import com.intellij.tapestry.intellij.view.TapestryProjectViewPane;
import com.intellij.tapestry.intellij.view.nodes.LibrariesNode;
import com.intellij.tapestry.intellij.view.nodes.PackageNode;
import com.intellij.tapestry.intellij.view.nodes.TapestryNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class SafeDeleteProvider
implements DeleteProvider {
    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/tapestry/intellij/actions/safedelete/SafeDeleteProvider", "deleteElement"));
        }
        Project project = (Project)dataContext.getData(DataKeys.PROJECT.getName());
        ArrayList<Object> totalElementsToDelete = new ArrayList<Object>();
        for (TreePath treePath : TapestryProjectViewPane.getInstance(project).getSelectionPaths()) {
            List<Object> elementsList = new ArrayList<PsiElement>();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (((TapestryNode)((Object)node.getUserObject())).getElement() instanceof PsiFile) {
                Object[] elements = new PsiElement[]{(PsiFile)((TapestryNode)((Object)node.getUserObject())).getElement()};
                ContainerUtil.addAll(totalElementsToDelete, (Object[])elements);
            }
            if (((TapestryNode)((Object)node.getUserObject())).getElement() instanceof PresentationLibraryElement) {
                PsiFile elementClass = ((IntellijResource)((PresentationLibraryElement)((TapestryNode)((Object)node.getUserObject())).getElement()).getElementClass().getFile()).getPsiFile();
                totalElementsToDelete.add(elementClass);
                for (IResource template : ((PresentationLibraryElement)((TapestryNode)((Object)node.getUserObject())).getElement()).getTemplate()) {
                    totalElementsToDelete.add(((IntellijResource)template).getPsiFile());
                }
                for (IResource catalog : ((PresentationLibraryElement)((TapestryNode)((Object)node.getUserObject())).getElement()).getMessageCatalog()) {
                    totalElementsToDelete.add(((IntellijResource)catalog).getPsiFile());
                }
            }
            if (!(node.getUserObject() instanceof PackageNode)) continue;
            boolean expanded = TapestryProjectViewPane.getInstance(project).getTree().isExpanded(new TreePath(node.getPath()));
            DefaultMutableTreeNode starterNode = node;
            totalElementsToDelete.add((PsiElement)((TapestryNode)((Object)node.getUserObject())).getElement());
            while (node != null && (node.getUserObject() instanceof PackageNode || ((TapestryNode)((Object)node.getUserObject())).getElement() instanceof PresentationLibraryElement)) {
                int numberChildren = ((TapestryNode)((Object)node.getUserObject())).getChildren().length;
                TapestryProjectViewPane.getInstance(project).getTree().expandPath(new TreePath(node.getPath()));
                for (int i = 0; i < numberChildren; ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                    if (!(((TapestryNode)((Object)child.getUserObject())).getElement() instanceof PresentationLibraryElement)) continue;
                    elementsList = SafeDeleteProvider.addElementToDelete(child, elementsList);
                }
                if (numberChildren > 0) {
                    node = node.getNextNode();
                    continue;
                }
                node = null;
            }
            totalElementsToDelete.addAll(elementsList);
            if (expanded) continue;
            TapestryProjectViewPane.getInstance(project).getTree().collapsePath(new TreePath(starterNode.getPath()));
        }
        SafeDeleteRefactoring safeDeleteRefactoring = RefactoringFactory.getInstance((Project)project).createSafeDelete(PsiUtilCore.toPsiElementArray(totalElementsToDelete));
        safeDeleteRefactoring.setPreviewUsages(true);
        safeDeleteRefactoring.run();
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/tapestry/intellij/actions/safedelete/SafeDeleteProvider", "canDeleteElement"));
        }
        Project project = (Project)dataContext.getData(DataKeys.PROJECT.getName());
        if (project == null || TapestryProjectViewPane.getInstance(project).getSelectionPaths() == null) {
            return false;
        }
        for (TreePath treePath : TapestryProjectViewPane.getInstance(project).getSelectionPaths()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            boolean canDelete = false;
            if (((TapestryNode)((Object)node.getUserObject())).getElement() instanceof PresentationLibraryElement && ((PresentationLibraryElement)((TapestryNode)((Object)node.getUserObject())).getElement()).getLibrary().getId().equals("application")) {
                canDelete = true;
            }
            if (((TapestryNode)((Object)node.getUserObject())).getElement() instanceof PsiFile && !(((PsiFile)((TapestryNode)((Object)node.getUserObject())).getElement()).getVirtualFile() instanceof VirtualFileImpl)) {
                canDelete = true;
            }
            if (node.getUserObject() instanceof PackageNode && IdeaUtils.findFirstParent(node, LibrariesNode.class) == null) {
                canDelete = true;
            }
            if (canDelete) continue;
            return false;
        }
        return true;
    }

    public static List addElementToDelete(DefaultMutableTreeNode child, List<PsiElement> elementsList) {
        PsiFile elementClass = ((IntellijResource)((PresentationLibraryElement)((TapestryNode)((Object)child.getUserObject())).getElement()).getElementClass().getFile()).getPsiFile();
        elementsList.add((PsiElement)IdeaUtils.findPublicClass(elementClass));
        for (IResource template : ((PresentationLibraryElement)((TapestryNode)((Object)child.getUserObject())).getElement()).getTemplate()) {
            elementsList.add((PsiElement)((IntellijResource)template).getPsiFile());
        }
        for (IResource catalog : ((PresentationLibraryElement)((TapestryNode)((Object)child.getUserObject())).getElement()).getMessageCatalog()) {
            elementsList.add((PsiElement)((IntellijResource)catalog).getPsiFile());
        }
        return elementsList;
    }
}

