/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.actions.createnew;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.actions.createnew.AddNewComponentDialog;
import com.intellij.tapestry.intellij.actions.createnew.AddNewElementAction;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.tapestry.intellij.util.Validators;
import com.intellij.tapestry.intellij.view.nodes.ComponentsNode;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class AddNewComponentAction
extends AddNewElementAction<ComponentsNode> {
    public AddNewComponentAction() {
        super(ComponentsNode.class);
    }

    @Override
    protected String getElementsRootPackage(@NotNull TapestryProject tapestryProject) {
        if (tapestryProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tapestryProject", "com/intellij/tapestry/intellij/actions/createnew/AddNewComponentAction", "getElementsRootPackage"));
        }
        return tapestryProject.getComponentsRootPackage();
    }

    public void actionPerformed(AnActionEvent event) {
        Module module = AddNewComponentAction.getModule(event);
        if (module == null) {
            return;
        }
        String defaultComponentPath = this.getDefaultElementPath(event, module);
        if (defaultComponentPath == null) {
            return;
        }
        AddNewComponentDialog addNewComponentDialog = new AddNewComponentDialog((Module)event.getDataContext().getData(DataKeys.MODULE.getName()), defaultComponentPath, false);
        DialogBuilder builder = new DialogBuilder(module.getProject());
        builder.setCenterPanel((JComponent)addNewComponentDialog.getContentPane());
        builder.setTitle("New Tapestry Component");
        builder.setButtonsAlignment(0);
        builder.setPreferredFocusComponent(addNewComponentDialog.getNameComponent());
        builder.setOkOperation(() -> {
            String componentName = addNewComponentDialog.getName();
            if (!Validators.isValidComponentName(componentName)) {
                Messages.showErrorDialog((String)"Invalid component name!", (String)CommonBundle.getErrorTitle());
                return;
            }
            String classSourceDir = addNewComponentDialog.getClassSourceDirectory().getPath();
            String templateSourceDir = addNewComponentDialog.getTemplateSourceDirectory().getPath();
            TapestryModuleSupportLoader.getInstance(module).getState().setNewComponentsClassesSourceDirectory(classSourceDir);
            TapestryModuleSupportLoader.getInstance(module).getState().setNewComponentsTemplatesSourceDirectory(templateSourceDir);
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    PsiDirectory classSourceDirectory = PsiManager.getInstance((Project)module.getProject()).findDirectory(addNewComponentDialog.getClassSourceDirectory());
                    PsiDirectory templateSourceDirectory = PsiManager.getInstance((Project)module.getProject()).findDirectory(addNewComponentDialog.getTemplateSourceDirectory());
                    if (addNewComponentDialog.isNotCreatingTemplate()) {
                        TapestryUtils.createComponent(module, classSourceDirectory, null, componentName, addNewComponentDialog.isReplaceExistingFiles());
                    } else {
                        TapestryUtils.createComponent(module, classSourceDirectory, templateSourceDirectory, componentName, addNewComponentDialog.isReplaceExistingFiles());
                    }
                }
                catch (IllegalStateException ex) {
                    Messages.showWarningDialog((Project)module.getProject(), (String)ex.getMessage(), (String)"Error creating page");
                }
            });
            builder.getWindow().dispose();
        });
        builder.showModal(true);
    }
}

