/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public final class StringUtils {
    public static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.length() == 1) {
            return string.toUpperCase(Locale.getDefault());
        }
        if (Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String uncapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.length() == 1) {
            return string.toLowerCase(Locale.getDefault());
        }
        if (Character.isLowerCase(string.charAt(0))) {
            return string;
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    public static boolean isNotEmpty(String value) {
        return value != null && !value.equals("");
    }

    public static String truncateWords(String value, int maxCharacters) {
        if (value.length() < maxCharacters) {
            return value;
        }
        return value.substring(0, value.substring(0, maxCharacters).lastIndexOf(32));
    }

    public static String toString(InputStream stream) throws IOException {
        int n;
        StringBuilder out = new StringBuilder();
        byte[] b = new byte[4096];
        while ((n = stream.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }
}

